<?php


/*
 *  Note: the format of the user preference file may seem.. well.. not orderly,
 *  to put it nicely. This is only due to the fact, that we have to remember
 *  that the configuration file may already be from an older version. Users
 *  are not going to want to re-enter information every time the administrator
 *  decides to update this absolutely wonderful plugin!
 */

global $debug; 

$debug = FALSE;

/* set this to true if you want to skip caching during debugging */

include_once (SM_PATH . 'plugins/wx200/temp.inc');
include_once (SM_PATH . 'plugins/wx200/barom.inc');
include_once (SM_PATH . 'plugins/wx200/wind.inc');
include_once (SM_PATH . 'plugins/wx200/humidity.inc');
include_once (SM_PATH . 'plugins/wx200/misc.inc');

function wx200_load_locations ()
{
	global $data_dir, $username;

	$locations = array ();

	for ($i = 0; $location = getPref ($data_dir, $username, 'wx200' . $i); $i++)
	{
		$temp = explode ('\\', $location);
		$locations[$i]['wx200d_ip'] = $temp[0];
		$locations[$i]['wx200d_port'] = $temp[1];
		$locations[$i]['position'] = $temp[2];
		$locations[$i]['wx200d_name'] = $temp[3];
	}

	return $locations;
}

function wx200_remove_location ($id)
{
	global $data_dir, $username;
	while ($nextLocation = getPref($data_dir, $username, 'wx200' . ($id + 1)))
	{
		setPref ($data_dir, $username, 'wx200' . $id, $nextLocation);
		$id++;
	}
	removePref ($data_dir, $username, 'wx200' . $id);
}

function wx200_display ($location, $theid)
{
	global $color, $left_size, $data_dir, $username, 
	       $weather_datafeed_timeout, $debug;
	
global $wx_datatype,$wx_length,$degree_type,$wind_type,$barom_type;
global $wx_length,$weather_datafeed_timeout;

// open a client connection
$fp = fsockopen ($location['wx200d_ip'], $location['wx200d_port'], $errno, $errstr,$weather_datafeed_timeout);

$result = '';

if (!$fp) {
    echo "Unable to Connect to wx200d server: $errno: $errstr";
} else {
    for($i=1;$i<147;$i++) { // we need 146 bytes, no more no less
      $result.=fread($fp,1);
    }
    if (!$result) {
	echo "Error: $errno: $errstr";
	return;
    }
    fclose($fp);
    $array = unpack('C*',$result);
    $end=1;
    $array = array_splice($array,0,-1); // dont need the first byte 
    while($end) { // loop until we hit last DTP group
      if (!$array) {
	break;
      }
      $group = $array[0];
      $dtp = $wx_datatype{$group};
      $length = $wx_length{$group};
      // grab the $length number of bytes 
      $array2 = array_splice($array,0,$length);
      if ($dtp == "humid") {
        $humidity_array = wx200_humidity($array2);
      } elseif ( $dtp == "temp") {
        $temp_array = wx200_temp($array2);
      } elseif ( $dtp == "barom") {
        $barom_array = wx200_barom($array2);
      } elseif ( $dtp == "rain") {
        //$rain_array = wx200_rain($array2);
      } elseif ( $dtp == "wind") {
        $wind_array = wx200_wind($array2);
      } elseif ( $dtp == "time") {
        //$time_array = wx200_time($array2);
      }
    }
}


        if ($location['position'] == "after")
        {
                print "<br>";
        }

        $table_width = 200;  //$left_size - 12;
        $table_width2 = $table_width - 2;

        $table_margin_right = 4;

        $table_margin_left = 4;

        $table_margin_top = 4;

        $table_margin_bottom = 4;

        $table_color_background = $color[9];

	$table_color_foreground = $color[3];

        $table_color_label = $color[6];

        $table_color_value = $color[11];

	echo "<table style=\"margin-left: " . $table_margin_left . "px; margin-right: " . $table_margin_right . "px; margin-top: " . $table_margin_top . "px; margin-bottom: " . $table_margin_bottom . "px;\" cellpadding=1 cellspacing=0 border=0 bgcolor=" . $table_color_background . " width=" . $table_width . ">";
	echo "<tr><td><table cellpadding=0 cellspacing=0 border=0  width=\"$table_width2\" bgcolor=\"$table_color_foreground\">";

// Name
	echo '<tr><td colspan=2 align=middle style="padding-left: 6px">';
	echo "<font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_label\"><b>",$location['wx200d_name'],"</b></font>";
	echo '</td></tr>';

// Clock
	echo '<tr><td align=left style="padding-left: 6px">';
	echo "<font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_label\">Clock:</font></td><td align=left valign=top style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_value\">",$humidity_array['ClockMon'],"/",$humidity_array['ClockDay'],"/",$humidity_array['ClockYear']," ",$humidity_array['ClockHour'],":",$humidity_array['ClockMin'],":",$humidity_array['ClockSec'],"</font>";
	echo '</td></tr>';

// Temperature Outside
	echo '<tr><td align=left style="padding-left: 6px">';
	echo "<font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_label\">Temperature:</font></td><td align=left valign=top style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_value\">",$temp_array['TempOutdoor'],"&deg;$degree_type</font>";
	echo '</td></tr>';

// Forcast
	echo '<tr><td align=left style="padding-left: 6px">';
echo "<font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_label\">Forcast:</font></td><td align=left valign=top style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_value\">",$barom_array['Forcast'],"</font>";
	echo '</td></tr>';

// Wind
	echo '<tr><td align=left style="padding-left: 6px" valign=top>';
echo "<font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_label\">Wind:</font></td><td align=left valign=top style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_value\">",$wind_array['WindCompass']," at ",$wind_array['WindSpeed']," ",$wind_array['WindType'],"</font>";
	echo '</td></tr>';

// Humidity
	echo '<tr><td align=left style="padding-left: 6px">';
echo "<font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_label\">Humidity:</font></td><td align=left valign=top style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_value\">",$humidity_array['HumidOutdoor'],"%</font>";
	echo '</td></tr>';

// Barometric Pressure
	echo '<tr><td align=left style="padding-left: 6px">';
echo "<font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_label\">Barometer:</font></td><td align=left valign=top style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=\"$table_color_value\">",$barom_array['BaromLocal']," ",$barom_array['BaromType'],"</font>";
	echo '</td></tr>';
	echo '</table></td></tr></table>';

	if ($location['position'] == "before")
	{
		print "<br>";
	}

	return;

}
?>
