<?php
//
// $Id: misc.inc,v 1.1 2003/06/12 01:27:41 mysigp226 Exp $
//
// Copyright (C) 2003 Tyler Allison <tyler@allisonhouse.com>
//
// (see the files README and COPYING for more details)
//

global $wx_datatype, $wx_length, $forcast, $trend, $compass;

// array constants taken from wx200.h in wx200d source code
$wx_datatype = array(0x8f => 'humid',
		     0x9f => 'temp',
		     0xaf => 'barom',
		     0xbf => 'rain',
		     0xcf => 'wind',
		     0xff => 'time');

$wx_length = array(0x8f => '35',
                   0x9f => '34',
                   0xaf => '31',
                   0xbf => '14',
                   0xcf => '27',
                   0xff => '5');

$forcast = array('Sunny','Cloudy','','Partly Cloudy','','','','Rain');
$trend = array('Rising', 'Steady', '', 'Falling');

$compass=array(' N ','NNE',' NE','ENE',' E ','ESE',' SE','SSE',' S ','SSW',' SW','WSW',' W ','WNW',' NW','NNW',' N ');


function CONVCOMP($degree) {
  global $compass;
  $temp = sprintf('%d',$degree/21.18);
  $temp = $compass[$temp];
  return($temp);
}

function CONVF($temp) {
  $temp = sprintf('%3.1f',($temp*1.8) +32);
  return($temp);
}

function TENTHS($byte) {
  return ($byte * 0.1);
}

function BIT($byte,$bit) {
  return ((($byte & (1 << $bit)) >> $bit));
}

function NUM($byte) {
  return (10 * HI($byte) + LO($byte));
}
function LO($byte) {
  return ($byte & 0x0f);
}

function HI($byte) {
  return (($byte & 0xf0) >> 4);
}
?>
