<?php 
//
// $Id: humidity.inc,v 1.2 2003/07/02 17:08:15 mysigp226 Exp $ 
//
// Copyright (C) 2003 Tyler Allison <tyler@allisonhouse.com>
//
// (see the files README and COPYING for more details)
//
//
// Humidity functions for the wx200d
//
//

function humidity_parse($array) {
//
// Take the array that was passed into the humidity function
// and turn the values into human readable and return an array
// for use in the display section
// 
// Uncomment the values you need for your display section. You
// could uncomment everything but why have your webserver 'parse'
// stuff your display section wont be using. It's here in case you need it.
//

  $clock_sec  = sprintf('%02x',$array[1]);
  $clock_min  = sprintf('%02x',$array[2]);
  $clock_hour = sprintf('%02x',$array[3]);
  $clock_day  = sprintf('%02x',$array[4]);
  $clock_mon  = sprintf('%02x',LO($array[5]));
  $clock_year  = "2003";

//  $a_low = sprintf('%x',$array[6]);
//  $a_hi  = sprintf('%x',$array[7]);

  $humid_in  = sprintf('%3x',$array[8]);

  $inhi_val  = sprintf('%3x',$array[9]);
  $inhi_min  = sprintf('%02x',$array[10]);
  $inhi_hour = sprintf('%02x',$array[11]);
  $inhi_day  = sprintf('%2x',$array[12]);
  $inhi_mon  = sprintf('%2x',LO($array[13]));

  $inlo_val  = sprintf('%2x%x',LO($array[14]),HI($array[13]));
  $inlo_min  = sprintf('%x%x',LO($array[15]),HI($array[14]));
  $inlo_hour = sprintf('%x%x',LO($array[16]),HI($array[15]));
  $inlo_day = sprintf('%x%x',LO($array[17]),HI($array[16]));
  $inlo_mon = sprintf('%2x',HI($array[17]));

//  $ina_hi = sprintf('%x',$array[18]);
//  $ina_lo = sprintf('%x',$array[19]);

  $humid_out = sprintf('%3x',$array[20]);

  $outhi_val  = sprintf('%3x',$array[21]);
  $outhi_min  = sprintf('%02x',$array[22]);
  $outhi_hour = sprintf('%02x',$array[23]);
  $outhi_day  = sprintf('%2x',$array[24]);
  $outhi_mon  = sprintf('%2x',LO($array[25]));

  $outlo_val  = sprintf('%2x%x',LO($array[26]),HI($array[25]));
  $outlo_min  = sprintf('%01x%x',LO($array[27]),HI($array[26]));
  $outlo_hour = sprintf('%01x%x',LO($array[28]),HI($array[27]));
  $outlo_day = sprintf('%01x%x',LO($array[29]),HI($array[28]));
  $outlo_mon = sprintf('%2x',HI($array[29]));
 
//  $outa_hi = sprintf('%x',$array[30]);
//  $outa_lo = sprintf('%x',$array[31]);

//
// Use the variables you uncommented above to build the array here.
// This should be self explanitory. 
//
  $humidity_array=array(
			'HumidIndoor'    => $humid_in,
	                'HumidOutdoor'   => $humid_out,
			'HumidIndoorHi'  => $inhi_val,
			'HumidOutdoorHi' => $outhi_val,
			'HumidIndoorLo' => $inlo_val,
			'HumidOutdoorLo'=> $outlo_val,

                        'HumidOutHiDay'    => $outhi_day,
                        'HumidOutHiMon'    => $outhi_mon,
                        'HumidOutHiHour'    => $outhi_hour,
                        'HumidOutHiMin'    => $outhi_min,

                        'HumidOutLoDay'    => $outlo_day,
                        'HumidOutLoMon'    => $outlo_mon,
                        'HumidOutLoHour'    => $outlo_hour,
                        'HumidOutLoMin'    => $outlo_min,

                        'HumidInHiDay'    => $inhi_day,
                        'HumidInHiMon'    => $inhi_mon,
                        'HumidInHiHour'    => $inhi_hour,
                        'HumidInHiMin'    => $inhi_min,

                        'HumidInLoDay'    => $inlo_day,
                        'HumidInLoMon'    => $inlo_mon,
                        'HumidInLoHour'    => $inlo_hour,
                        'HumidInLoMin'    => $inlo_min,
			'ClockSec'	=> $clock_sec,
			'ClockMin'	=> $clock_min,
			'ClockHour'	=> $clock_hour,
			'ClockDay'	=> $clock_day,
			'ClockMon'	=> $clock_mon,
			'ClockYear'	=> $clock_year

			);

  return ($humidity_array);
}

function wx200_humidity($array) {

  # Can return 0xee (238) in sub zero weather
  # so deal with it before we parse
  if ($array[8] > 0x99) $array[8] = 0x99;
  if ($array[20] > 0x99) $array[20] = 0x99;

  $humidity_array = humidity_parse($array);
  return $humidity_array;

}
?>
