<?php
//
// $Id: barom.inc,v 1.2 2003/07/26 02:15:08 mysigp226 Exp $ 
//
// Copyright (C) 2003 Tyler Allison <tyler@allisonhouse.com>
//
// (see the files README and COPYING for more details)
//
//
// Barom functions for the wx200d
//
//

function barom_parse($array) {
//
// Take the array that was passed into the baro function
// and turn the values into human readable and return an array
// for use in the display section
//
// Uncomment the values you need for your display section. You
// could uncomment everything but why have your webserver 'parse'
// stuff your display section wont be using. It's here in case you need it.
//
  global $degree_type;
  global $forcast;
  global $trend;

  if ($array[18] == 0x22) $array[18] = 0x00;

  $barom_local = sprintf('%d',1000 * NUM($array[2]) + 10 * NUM($array[1]));
  $barom_local = sprintf('%d',substr($barom_local,0,-1));
  $barom_sea = sprintf('%d',10000 * LO($array[5]) + 100 * NUM($array[4]) + NUM($array[3]));
  $barom_sea = sprintf('%d',substr($barom_sea,0,-1));
  $barom_format = sprintf('%d',HI($array[5] & 0x30));
  $barom_pred = sprintf('%d',LO($array[6]));
  $barom_pred = $forcast[$barom_pred-1];
  $barom_trend = sprintf('%d',HI($array[6] & 0x70));
  $barom_trend = $trend[$barom_trend-1];
  // barom_trend is broken if you have a WMR968!!!! 
 
  // 6 unused
  $dew_in = sprintf('%3d.0',NUM($array[7]));

  $inhi_val = sprintf('%3d.0',NUM($array[8]));
  $inhi_min = sprintf('%02d',NUM($array[9]));
  $inhi_hour = sprintf('%02d',NUM($array[10]));
  $inhi_day = sprintf('%2d',NUM($array[11]));
  $inhi_mon = sprintf('%2d',LO($array[12]));
  
  $inlo_val = sprintf('%3d.0',10 * LO($array[13]) + HI($array[12]));
  $inlo_min = sprintf('%02d',10 * LO($array[14]) + HI($array[13]));
  $inlo_hour = sprintf('%02d',10 * LO($array[15]) + HI($array[14]));
  $inlo_day = sprintf('%2d',10 * LO($array[16]) + HI($array[15]));
  $inlo_mon = sprintf('%2d',HI($array[16]));

  // ina.lo
  // outa.lo
  
  $dew_out = sprintf('%3d.0',NUM($array[18]));


  $outhi_val = sprintf('%3d.0',NUM($array[19]));
  $outhi_min = sprintf('%02d',NUM($array[20]));
  $outhi_hour = sprintf('%02d',NUM($array[21]));
  $outhi_day = sprintf('%2d',NUM($array[22]));
  $outhi_mon = sprintf('%2d',LO($array[23]));

  $outlo_val = sprintf('%3d.0',10 * LO($array[24]) + HI($array[23]));
  $outlo_min = sprintf('%02d',10 * LO($array[25]) + HI($array[24]));
  $outlo_hour = sprintf('%02d',10 * LO($array[26]) + HI($array[25]));
  $outlo_day = sprintf('%2d',10 * LO($array[27]) + HI($array[26]));
  $outlo_mon = sprintf('%2d',HI($array[27]));

  if ($degree_type == "F") {
    $dew_out = CONVF($dew_out);
    $dew_in = CONVF($dew_in);
    $inhi_val = CONVF($inhi_val);
    $outhi_val = CONVF($outhi_val);
    $inlo_val = CONVF($inlo_val);
    $outlo_val = CONVF($outlo_val);
  }

// 0=in, 1=mm, 2=mb, 3=hpa
// we are going to assume we get the barom rate in type 3 (hpa) if not  error.
// we could base our conversion on the barom_format context but too much work
// for now.
    if ($barom_format != '3') {
      echo "<b>Barometric format from wx200d is not hpa so conversion is broken!! barom_format should be 3 but is actually $barom_format</b><br>";
    }


//
// Use the variables you uncommented above to build the array here.
// This should be self explanitory.
//
  $barom_array=array(
			'Forcast'	=> $barom_pred,
			'Trend'		=> $barom_trend,
                        'BaromLocal'    => $barom_local,
                        'BaromSea'    => $barom_sea,
			'DewIndoor'	=> $dew_in,
			'DewOutdoor'	=> $dew_out,
                        'DewIndoorHi'    => $inhi_val,
                        'DewOutdoorHi'    => $outhi_val,
                        'DewIndoorLo'    => $inlo_val,
                        'DewOutdoorLo'    => $outlo_val,

                        'DewOutHiDay'    => $outhi_day,
                        'DewOutHiMon'    => $outhi_mon,
                        'DewOutHiHour'    => $outhi_hour,
                        'DewOutHiMin'    => $outhi_min,

                        'DewOutLoDay'    => $outlo_day,
                        'DewOutLoMon'    => $outlo_mon,
                        'DewOutLoHour'    => $outlo_hour,
                        'DewOutLoMin'    => $outlo_min,

                        'DewInHiDay'    => $inhi_day,
                        'DewInHiMon'    => $inhi_mon,
                        'DewInHiHour'    => $inhi_hour,
                        'DewInHiMin'    => $inhi_min,

                        'DewInLoDay'    => $inlo_day,
                        'DewInLoMon'    => $inlo_mon,
                        'DewInLoHour'    => $inlo_hour,
                        'DewInLoMin'    => $inlo_min,

                        );

// 0=in, 1=mm, 2=mb, 3=hpa
    if ($barom_format == '3') {
        $barom_array['BaromType']='hPa';
    } else {
        // do nothing until we support more conversions
        $rain_array['BaromType']='hPa';
    }

  return ($barom_array);
}

function wx200_barom($array) {
  $barom_array = barom_parse($array);
  return($barom_array);
}
?>
