<?php

/**
  * SquirrelMail Login Manager Plugin
  * Copyright (c) 2003-2006 Paul Lesneiwski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage vlogin
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_vlogin() {

  global $squirrelmail_plugin_hooks;


  $squirrelmail_plugin_hooks['login_before']['vlogin']               = 'vlogin_domain';

  $squirrelmail_plugin_hooks['login_verified']['vlogin']             = 'vlogin_save_original';

  $squirrelmail_plugin_hooks['optpage_loadhook_display']['vlogin']   = 'vlogin_display_options';
  $squirrelmail_plugin_hooks['optpage_loadhook_personal']['vlogin']  = 'vlogin_display_options';
  $squirrelmail_plugin_hooks['optpage_loadhook_folder']['vlogin']    = 'vlogin_display_options';
  $squirrelmail_plugin_hooks['optpage_loadhook_highlight']['vlogin'] = 'vlogin_display_options';
  $squirrelmail_plugin_hooks['optpage_loadhook_order']['vlogin']     = 'vlogin_display_options';


  // not technically necessary when $useSessionBased is turned off, but...
  // as of SM 1.5.2 no dynamic code is run in this function (this function
  // is parsed at config time and never actually run by SM at all)
  //
  $squirrelmail_plugin_hooks['login_cookie']['vlogin'] = 'vlogin_overrideSmConfig';
  $squirrelmail_plugin_hooks['webmail_top']['vlogin'] = 'vlogin_overrideSmConfig';


  // In 1.5.2, just register the Multilogin plugin on the config 
  // override hook, no need to activate multilogin or patch the 
  // source code.  Whew.
  //
  $squirrelmail_plugin_hooks['config_override']['multilogin'] = 'multilogin_sqoverride_config';


  // this code only works pre 1.5.2 and is deprecated; users should
  // migrate to $useSessionBased anyway... 1.5.2 no longer requires 
  // patching to do so
  //
  include_once(SM_PATH . 'plugins/vlogin/functions.php');
  load_vlogin_config();
  global $useSessionBased;
  if (!$useSessionBased)
  {

     include_once(SM_PATH . 'plugins/vlogin/functions.php');
     overrideSmConfig(array('squirrelmail_plugin_init_vlogin')); // dummy hook name

  }


}



/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');



/**
  * Returns info about this plugin
  *
  */
function vlogin_info()
{

   return array(
                 'english_name' => 'Login Manager',
                 'version' => '3.9.0',
                 'required_sm_version' => '1.2.7',
                 'requires_configuration' => 0,
                 'requires_source_patch' => 0,
                 'required_php_version' => '4.0.6',
                 'summary' => 'Helps manage and manipulate usernames given at login time, and allows the use of different SquirrelMail settings (such as login page image, or IMAP server) for each domain, each user, or each user group',
                 'details' => 'VLogin is a plugin for SquirrelMail that:'
         . '<ul><li> helps manage and manipulate usernames given at login time<br /><br />' 
         . '<li> allows the use of different SquirrelMail settings (such as login page image, or IMAP server) for each domain, each user, or each user group</ul>'
         . 'Vlogin is both useful if you just need to make sure that usernames given on the login page are consistent and/or if you host more than one domain and wish to customize SquirrelMail for each domain but do not want to install and manage a separate SquirrelMail installation for each one.<br /><br />' 
         . 'Vlogin is also meant to help your users: if your user accounts are of the form "jose@example.net", it allows users to log in by only typing "jose" in the username field.<br /><br />' 
         . 'Finally, Vlogin is capable of supporting fairly complex systems where the SquirrelMail settings, appearance, access levels, and behaviors are based on username, domain or "service level" (user group).<br /><br />' 
         . 'Despite the plugin name, even single-domain servers may find very useful functionality herein, such as username consistency/simplicity, or per-user settings or "service level" user settings groups, etc.<br /><br />' 
         . 'Some of Vlogin\'s helpful features include:'
         . '<ul><li> make sure all usernames given on login page do not have any domain portion in them'
         . '<li> make sure all usernames given on login page have the SquirrelMail default domain appended to them'
         . '<li> make sure all usernames given on login page have the domain that corresponds to the domain in the URL of the login page appended to them'
         . '<li> allow users to log in with just a "user" when in fact their IMAP login might be something like "username@domain.com"'
         . '<li> show a different image on the login page for each of your domains'
         . '<li> change most any SquirrelMail configuration setting on a per-domain per-service level, or even per-user basis'
         . '<li> access a sendmail-style virtual users table'
         . '<li> change IMAP servers (or any other settings) on a per-domain, per-service level, or even on a per-user basis'
         . '<li> enable or disable certain plugins on a per-domain, per-service level or per-user basis'
         . '<li> disable certain option page items on a per-domain, per-service level or per-user basis'
         . '<li> dealias Qmail/Vpopmail aliased domains'
         . '<li> domain name translation'
         . '<li> access per-domain, per-service level or per-user settings stored in a SQL database'
         . '<li> much more...</ul>',
               );

}



/**
  * Returns version info about this plugin
  *
  */
function vlogin_version() 
{

   $info = vlogin_info();
   return $info['version'];

}



/**
  * Remap Username When Logging In
  *
  */
function vlogin_domain($args) 
{

   include_once(SM_PATH . 'plugins/vlogin/functions.php');
   vlogin_domain_do($args);

}



/**
  * Save original username used to log in
  *
  */
function vlogin_save_original() 
{

   include_once(SM_PATH . 'plugins/vlogin/functions.php');
   vlogin_save_original_do();

}



/**
  * Allows control over which options are displayed on options pages
  *
  */
function vlogin_display_options() 
{

   include_once(SM_PATH . 'plugins/vlogin/functions.php');
   vlogin_display_options_do();

}



/**
  * Override Default Config Values
  *
  */
function vlogin_overrideSmConfig($args) 
{

   include_once(SM_PATH . 'plugins/vlogin/functions.php');
   overrideSmConfig($args);

}


