<?php

function squirrelmail_plugin_init_vlogin() {

  global $data_dir, $squirrelmail_plugin_hooks, $username,
         $org_name, $org_logo, $org_logo_width, $org_logo_height,
         $org_title, $signout_page, $frame_top, $squirrelmail_default_language;

  global $domain, $imapServerAddress, $imapPort, $useSendmail, $smtpServerAddress,
         $smtpPort, $sendmail_path, $use_authenticated_smtp,
         $pop_before_smtp, $imap_server_type, $invert_time, 
         $optional_delimiter;
         
  global $default_folder_prefix, $trash_folder, $sent_folder, $draft_folder,
         $default_move_to_trash, $default_move_to_sent, $default_save_as_draft,
         $show_prefix_option, $list_special_folders_first, $use_special_folder_color,
         $auto_expunge, $default_sub_of_inbox, $show_contain_subfolders_option,
         $default_unseen_notify, $default_unseen_type, $auto_create_special,
         $delete_folder, $noselect_fix_enable;
          
      
  global $numberOfDotSections, $checkByExcludeList, $at, $dot, $dontUseHostName,
         $smHostIsDomainThatUserLoggedInWith, $virtualDomainDataDir;
      
  
  $squirrelmail_plugin_hooks['login_before']['vlogin'] = 'vlogin_domain';

  // get global variable for versions of PHP < 4.1 
  //
  if ((float)substr(PHP_VERSION,0,3) < 4.1) {
    global $HTTP_SERVER_VARS;
    $_SERVER = $HTTP_SERVER_VARS;
  }

  // grab hostname into local var
  //
  $hostname = $_SERVER['HTTP_HOST'];

  include_once('../plugins/vlogin/config.php');


   // set domain if the $smHostIsDomainThatUserLoggedInWith
   // flag is on...
   //
   if ($smHostIsDomainThatUserLoggedInWith)
      $domain = deconstructDomainName($_SERVER['HTTP_HOST']);
      

  // override data_dir if the $virtualDomainDataDir variable 
  // has been specified
  //
  if (!empty($virtualDomainDataDir)) {
     $data_dir = $virtualDomainDataDir;
     $data_dir = str_replace('###VIRTUAL_DOMAIN###', 
                             deconstructDomainName($_SERVER['HTTP_HOST']), 
                             $data_dir);
  }


  // override the org_logo and other stuff if we find a match
  //
  foreach (array_keys($virtualDomains) as $virtualDomain) {

    if (stristr($hostname, $virtualDomain)) {


      // set domain-specific global variables
      //
      if (in_array('org_logo', array_keys($virtualDomains[$virtualDomain])))
          $org_logo = $virtualDomains[$virtualDomain]['org_logo'];
      if (in_array('org_title', array_keys($virtualDomains[$virtualDomain])))
          $org_title = $virtualDomains[$virtualDomain]['org_title'];
      if (in_array('org_name', array_keys($virtualDomains[$virtualDomain])))
          $org_name = $virtualDomains[$virtualDomain]['org_name'];
      if (in_array('org_logo_width', array_keys($virtualDomains[$virtualDomain])))
          $org_logo_width = $virtualDomains[$virtualDomain]['org_logo_width'];
      if (in_array('org_logo_height', array_keys($virtualDomains[$virtualDomain])))
          $org_logo_height = $virtualDomains[$virtualDomain]['org_logo_height'];
      if (in_array('signout_page', array_keys($virtualDomains[$virtualDomain])))
          $signout_page = $virtualDomains[$virtualDomain]['signout_page'];
      if (in_array('frame_top', array_keys($virtualDomains[$virtualDomain])))
          $frame_top = $virtualDomains[$virtualDomain]['frame_top'];
      if (in_array('squirrelmail_default_language', array_keys($virtualDomains[$virtualDomain])))
          $squirrelmail_default_language = $virtualDomains[$virtualDomain]['squirrelmail_default_language'];
      if (in_array('domain', array_keys($virtualDomains[$virtualDomain])))
          $domain = $virtualDomains[$virtualDomain]['domain'];

      if (in_array('imapServerAddress', array_keys($virtualDomains[$virtualDomain])))
          $imapServerAddress = $virtualDomains[$virtualDomain]['imapServerAddress'];
      if (in_array('imapPort', array_keys($virtualDomains[$virtualDomain])))
          $imapPort = $virtualDomains[$virtualDomain]['imapPort'];
      if (in_array('useSendmail', array_keys($virtualDomains[$virtualDomain])))
          $useSendmail = $virtualDomains[$virtualDomain]['useSendmail'];
      if (in_array('smtpServerAddress', array_keys($virtualDomains[$virtualDomain])))
          $smtpServerAddress = $virtualDomains[$virtualDomain]['smtpServerAddress'];
      if (in_array('smtpPort', array_keys($virtualDomains[$virtualDomain])))
          $smtpPort = $virtualDomains[$virtualDomain]['smtpPort'];
      if (in_array('sendmail_path', array_keys($virtualDomains[$virtualDomain])))
          $sendmail_path = $virtualDomains[$virtualDomain]['sendmail_path'];
      if (in_array('use_authenticated_smtp', array_keys($virtualDomains[$virtualDomain])))
          $use_authenticated_smtp = $virtualDomains[$virtualDomain]['use_authenticated_smtp'];
      if (in_array('pop_before_smtp', array_keys($virtualDomains[$virtualDomain])))
          $pop_before_smtp = $virtualDomains[$virtualDomain]['pop_before_smtp'];
      if (in_array('imap_server_type', array_keys($virtualDomains[$virtualDomain])))
          $imap_server_type = $virtualDomains[$virtualDomain]['imap_server_type'];
      if (in_array('invert_time', array_keys($virtualDomains[$virtualDomain])))
          $invert_time = $virtualDomains[$virtualDomain]['invert_time'];
      if (in_array('optional_delimiter', array_keys($virtualDomains[$virtualDomain])))
          $optional_delimiter = $virtualDomains[$virtualDomain]['optional_delimiter'];

      if (in_array('default_folder_prefix', array_keys($virtualDomains[$virtualDomain])))
          $default_folder_prefix = $virtualDomains[$virtualDomain]['default_folder_prefix'];
      if (in_array('trash_folder', array_keys($virtualDomains[$virtualDomain])))
          $trash_folder = $virtualDomains[$virtualDomain]['trash_folder'];
      if (in_array('sent_folder', array_keys($virtualDomains[$virtualDomain])))
          $sent_folder = $virtualDomains[$virtualDomain]['sent_folder'];
      if (in_array('draft_folder', array_keys($virtualDomains[$virtualDomain])))
          $draft_folder = $virtualDomains[$virtualDomain]['draft_folder'];
      if (in_array('default_move_to_trash', array_keys($virtualDomains[$virtualDomain])))
          $default_move_to_trash = $virtualDomains[$virtualDomain]['default_move_to_trash'];
      if (in_array('default_move_to_sent', array_keys($virtualDomains[$virtualDomain])))
          $default_move_to_sent = $virtualDomains[$virtualDomain]['default_move_to_sent'];
      if (in_array('default_save_as_draft', array_keys($virtualDomains[$virtualDomain])))
          $default_save_as_draft = $virtualDomains[$virtualDomain]['default_save_as_draft'];
      if (in_array('show_prefix_option', array_keys($virtualDomains[$virtualDomain])))
          $show_prefix_option = $virtualDomains[$virtualDomain]['show_prefix_option'];
      if (in_array('list_special_folders_first', array_keys($virtualDomains[$virtualDomain])))
          $list_special_folders_first = $virtualDomains[$virtualDomain]['list_special_folders_first'];
      if (in_array('use_special_folder_color', array_keys($virtualDomains[$virtualDomain])))
          $use_special_folder_color = $virtualDomains[$virtualDomain]['use_special_folder_color'];
      if (in_array('auto_expunge', array_keys($virtualDomains[$virtualDomain])))
          $auto_expunge = $virtualDomains[$virtualDomain]['auto_expunge'];
      if (in_array('default_sub_of_inbox', array_keys($virtualDomains[$virtualDomain])))
          $default_sub_of_inbox = $virtualDomains[$virtualDomain]['default_sub_of_inbox'];
      if (in_array('show_contain_subfolders_option', array_keys($virtualDomains[$virtualDomain])))
          $show_contain_subfolders_option = $virtualDomains[$virtualDomain]['show_contain_subfolders_option'];
      if (in_array('default_unseen_notify', array_keys($virtualDomains[$virtualDomain])))
          $default_unseen_notify = $virtualDomains[$virtualDomain]['default_unseen_notify'];
      if (in_array('default_unseen_type', array_keys($virtualDomains[$virtualDomain])))
          $default_unseen_type = $virtualDomains[$virtualDomain]['default_unseen_type'];
      if (in_array('auto_create_special', array_keys($virtualDomains[$virtualDomain])))
          $auto_create_special = $virtualDomains[$virtualDomain]['auto_create_special'];
      if (in_array('delete_folder', array_keys($virtualDomains[$virtualDomain])))
          $delete_folder = $virtualDomains[$virtualDomain]['delete_folder'];
      if (in_array('noselect_fix_enable', array_keys($virtualDomains[$virtualDomain])))
          $noselect_fix_enable = $virtualDomains[$virtualDomain]['noselect_fix_enable'];

      if (in_array('numberOfDotSections', array_keys($virtualDomains[$virtualDomain])))
          $numberOfDotSections = $virtualDomains[$virtualDomain]['numberOfDotSections'];
      if (in_array('checkByExcludeList', array_keys($virtualDomains[$virtualDomain])))
          $checkByExcludeList = $virtualDomains[$virtualDomain]['checkByExcludeList'];
      if (in_array('at', array_keys($virtualDomains[$virtualDomain])))
          $at = $virtualDomains[$virtualDomain]['at'];
      if (in_array('dot', array_keys($virtualDomains[$virtualDomain])))
          $dot = $virtualDomains[$virtualDomain]['dot'];
      if (in_array('dontUseHostName', array_keys($virtualDomains[$virtualDomain])))
          $dontUseHostName = $virtualDomains[$virtualDomain]['dontUseHostName'];
      if (in_array('smHostIsDomainThatUserLoggedInWith', array_keys($virtualDomains[$virtualDomain])))
          $smHostIsDomainThatUserLoggedInWith = $virtualDomains[$virtualDomain]['smHostIsDomainThatUserLoggedInWith'];


      if ($smHostIsDomainThatUserLoggedInWith)
          $domain = deconstructDomainName($_SERVER['HTTP_HOST']);

      
      if (in_array('data_dir', array_keys($virtualDomains[$virtualDomain]))) {
          $data_dir = $virtualDomains[$virtualDomain]['data_dir'];
          $data_dir = str_replace('###VIRTUAL_DOMAIN###',
                                  deconstructDomainName($_SERVER['HTTP_HOST']),
                                  $data_dir);
      }


      // exit this loop
      // 
      break;

    }

  }

}

// Magic happens below.
function vlogin_domain() {


  global $plugins, $login_username, $$login_username;
  global $numberOfDotSections, $checkByExcludeList, $at, $dot, $dontUseHostName;


  // get global variable for versions of PHP < 4.1
  //
  if ((float)substr(PHP_VERSION,0,3) < 4.1) {
    global $HTTP_SERVER_VARS;
    $_SERVER = $HTTP_SERVER_VARS;
  }


  // grab hostname into local var
  //
  $hostname = $_SERVER['HTTP_HOST'];

  include_once('../plugins/vlogin/config.php');


  $username=$login_username;
  
  // if password_forget is loaded, use the obfuscated name
  if (in_array('password_forget',$plugins) && $$login_username!="") {
    $username=$$login_username;
  }

  // find domain name.  Only truly important bit.

  // check and see if they decided to insert the host anyways
  // or we don't want to use the host name...
  //
  if( !$dontUseHostName && !strstr( $username, $at ) ) { 


    $hostname = deconstructDomainName($hostname);


    // assign realname using parsed hostname
    //
    $realname = $username . $at . $hostname;


  } else {
    $realname = $username;
  }
  
  // if password_forget is loaded, use the obfuscated name
  if (in_array('password_forget',$plugins) && $$login_username!="") $$login_username=$realname;
  else $login_username=$realname;

}


// Does the actual hostname deconstruction
//
function deconstructDomainName($hostname) {

  global $notPartOfDomainName, $numberOfDotSections, 
         $checkByExcludeList, $at, $dot, $dontUseHostName;
  include_once('../plugins/vlogin/config.php');


  // if enabled, take only as many pieces of hostname as specified 
  // by desired number of dot sections
  //
  if ($numberOfDotSections > 0) {

     // lop off first piece of hostname until 
     // number of dot sections is same as desired
     //
     while (sizeof(explode('.', $hostname)) > $numberOfDotSections) {

       $hostname = substr($hostname, strpos($hostname, '.') + 1);
        
     }

   }

   // if enabled, chop off any of the undesired host 
   // name pieces (from front only)
   //
   if ($checkByExcludeList) {
    
     $hostnameLengthBefore = 0;
     $hostnameLengthAfter = strlen($hostname);
      

     // no guarantee what order they are in, so just loop until no 
     // more are found and length remains the same
     //
     while($hostnameLengthBefore != $hostnameLengthAfter) {

       $hostnameLengthBefore = strlen($hostname);
        

       // check each of the list of irrelevant pieces
       //
       foreach ($notPartOfDomainName as $ignoreName) {
        

        // remove it from front of hostname if found
        //
        if (is_integer(strpos($hostname, $ignoreName . '.'))
                   and strpos($hostname, $ignoreName . '.') == 0) {
          
          $hostname = substr($hostname, strpos($hostname, 0) 
                    + strlen($ignoreName) + 1);
            
        }
          
      }
  
      $hostnameLengthAfter = strlen($hostname);

    }

  }


  // just in case they need a different '.' seperator
  $hostname = str_replace( ".", $dot, $hostname );


  return $hostname;

}

?>
