<?php
/*
 *
 *  calendar.php
 *
 *  Copyright (c) 2001 Michal Szczotka <michal@tuxy.org>
 *  Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 *  Displays the main calendar page (month view).
 *  Modified by Jason Munro 6/28/02
 *
 */
define('SM_PATH', '../../');

/* Calender plugin required files. */
require_once(SM_PATH . 'plugins/calendar/calendar_data.php');
require_once(SM_PATH . 'plugins/calendar/functions.php');
require_once(SM_PATH . 'plugins/calendar/shared_functions.php');

/* SquirrelMail required files. */
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/strings.php');
require_once(SM_PATH . 'functions/date.php');
require_once(SM_PATH . 'config/config.php');
require_once(SM_PATH . 'functions/page_header.php');
require_once(SM_PATH . 'include/load_prefs.php');
require_once(SM_PATH . 'functions/html.php');

/* get globals */

if (isset($_GET['cal'])) {
    $cal = $_GET['cal'];
}
if (isset($_POST['cal'])) {
    $cal = $_POST['cal'];
}

$checkup = check_me($data_dir, $_SESSION['username'], $cal);
if ($checkup == 'no') {
    print "<center><font color=\"red\"><br><br><big><b>" . _("You do not have access to this calendar") . "</b></big></font></center>\n";
    exit();
}

/* get globals */
if (isset($_GET['month'])) {
    $month = $_GET['month'];
}
if (isset($_GET['year'])) {
    $year = $_GET['year'];
}
if (isset($_POST['year'])) {
    $year = $_POST['year'];
}
if (isset($_POST['month'])) {
    $month = $_POST['month'];
}
/* got 'em */

//display upper part of month calendar view
function startcalendar() {
    global $year, $month, $day, $color, $cal;

    $prev_date = mktime(0, 0, 0, $month - 1, 1, $year);
    $act_date  = mktime(0, 0, 0, $month, 1, $year);
    $next_date = mktime(0, 0, 0, $month + 1, 1, $year);
    $prev_month = date( 'm', $prev_date );
    $next_month = date( 'm', $next_date);
    $prev_year = date( 'Y', $prev_date);
    $next_year = date( 'Y', $next_date );
    $self = 'calendar.php';

    echo html_tag( 'tr', "\n".
               html_tag( 'td', "\n".
                   html_tag( 'table', '', '', $color[0], 'width="100%" border="0" cellpadding="2" cellspacing="1"' ) .
                       html_tag( 'tr', "\n".
                            html_tag( 'th',
                                "<a href=\"$self?cal=".urlencode($cal)."&year=".($year-1)."&month=$month\">&lt;&lt;&nbsp;".($year-1)."</a>"
                            ) . "\n".
                            html_tag( 'th',
                                "<a href=\"$self?cal=".urlencode($cal)."&year=$prev_year&month=$prev_month\">&lt;&nbsp;" .
                                date_intl( 'M', $prev_date). "</a>"
                            ) . "\n".
                            html_tag( 'th', date_intl( 'F Y', $act_date ), '', $color[0], 'colspan="3"') .
                            html_tag( 'th',
                                "<a href=\"$self?cal=".urlencode($cal)."&year=$next_year&month=$next_month\">" .
                                date_intl( 'M', $next_date) . "&nbsp;&gt;</a>"
                            ) . "\n".
                            html_tag( 'th',
                                "<a href=\"$self?cal=".urlencode($cal)."&year=".($year+1)."&month=$month\">".($year+1)."&nbsp;&gt;&gt;</a>"
                            )
                       ) . "\n".
                       html_tag( 'tr',
                           html_tag( 'th', _("Sunday"), '', $color[5], 'width="14%" width="90"' ) ."\n" .
                           html_tag( 'th', _("Monday"), '', $color[5], 'width="14%" width="90"' ) ."\n" .
                           html_tag( 'th', _("Tuesday"), '', $color[5], 'width="14%" width="90"' ) ."\n" .
                           html_tag( 'th', _("Wednesday"), '', $color[5], 'width="14%" width="90"' ) ."\n" .
                           html_tag( 'th', _("Thursday"), '', $color[5], 'width="14%" width="90"' ) ."\n" .
                           html_tag( 'th', _("Friday"), '', $color[5], 'width="14%" width="90"' ) ."\n" .
                           html_tag( 'th', _("Saturday"), '', $color[5], 'width="14%" width="90"' ) ."\n"
                       )
               ) ,
           '', $color[0] ) ."\n";

}

//main logic for month view of calendar
function drawmonthview() {
    global $year, $month, $day, $color, $calendardata, $todayis, $cal;
    $aday = 1 - date('w', mktime(0, 0, 0, $month, 1, $year));
    $days_in_month = date('t', mktime(0, 0, 0, $month, 1, $year));
    while ($aday <= $days_in_month) {
        echo html_tag( 'tr' );
        for ($j=1; $j<=7; $j++) {
            $cdate="$month";
            ($aday<10)?$cdate=$cdate."0$aday":$cdate=$cdate."$aday";
            $cdate=$cdate."$year";
            if ( $aday <= $days_in_month && $aday > 0){
                echo html_tag( 'td', '', 'left', $color[4], 'height="50" valign="top"' ) ."\n".
                     html_tag( 'div', '', 'right' );
                echo(($cdate==$todayis) ? "<font size=-1 color=$color[1]>[ " . _("TODAY") . " ] " : "<font size=-1>");
                echo "<a href=day.php?cal=".urlencode($cal)."&year=$year&month=$month&day=";
                echo(($aday<10) ? "0" : "");
                echo "$aday>$aday</a></font></div>";
            } else {
                echo html_tag( 'td', '', 'left', $color[0]) ."\n".
                     "&nbsp;";
            }
            if (isset($calendardata[$cdate])){
                $i=0;
                while ($calfoo = each($calendardata[$cdate])) {
                    $calbar = $calendardata[$cdate][$calfoo['key']];
                    echo ($calbar['priority']==1) ? "<a href=\"#\" style=\"text-decoration:none; color: $color[1]\" title=\"" . eregi_replace('<br[[:space:]]*/?[[:space:]]*>', "\n", $calbar['message']) . "\">$calbar[title]</a><br>\n" : "<a href=\"#\" style=\"text-decoration:none; color: $color[8]\" title=\"" . eregi_replace('<br[[:space:]]*/?[[:space:]]*>', "\n", $calbar['message']) . "\">$calbar[title]</a><br>\n";
                    $i=$i+1;
                    if($i==2){
                        break;
                    }
                }
            }
            echo "\n</td>\n";
            $aday++;
        }
        echo '</tr>';
    }
}

//end of monthly view and form to jump to any month and year
function endcalendar() {
    global $year, $month, $day, $color, $cal;

    global $data_dir, $username;
    $shared_list = read_calendar_list($data_dir, 'shared');
    $public_list = read_calendar_list($data_dir, 'public');
    $ccode = get_user_code($data_dir, $username);
    if ($ccode == '') {
        $cal_num = count($shared_list);
        $ccode = str_repeat("0", $cal_num);
    }


    echo html_tag( 'tr' ) ."\n" .
           html_tag( 'td', '', 'left', '', 'colspan="5"' ) ."\n" .
         "          <FORM NAME=caljump ACTION=\"calendar.php\" METHOD=POST>\n".
         "          <SELECT NAME=\"year\">\n";
    select_option_year($year);
    echo "          </SELECT>\n".
         "          <SELECT NAME=\"month\">\n";
    select_option_month($month);
    echo "          </SELECT>\n".
         '         <INPUT TYPE=SUBMIT VALUE="' . _("Go") . "\">\n".
         "         <input type=hidden name=cal value=\"$cal\">\n".
         "          </FORM>\n".
         "          </TD>\n".
         "          <TD COLSPAN=2><FORM NAME=\"calswitch\"><SELECT NAME=\"calselect\">\n";
    $count = count($public_list);
    for ($x=0;$x<$count;$x++) {
        $url_calendar=urlencode($public_list[$x]);
        echo "<OPTION VALUE=\"calendar.php?cal=$url_calendar\">$public_list[$x]</OPTION>\n";
    }
    $code = preg_split('//', $ccode, -1, PREG_SPLIT_NO_EMPTY);
    for ($x=0;$x<count($shared_list);$x++) {
        $url_calendar = urlencode($shared_list[$x]);
            switch ($code[$x]) {
                    case 0:
                    break;
                    case 1:
                    case 2:
                    echo "<OPTION VALUE=\"calendar.php?cal=$url_calendar\">$shared_list[$x]</OPTION>\n";
                    break;
                    default:
                    break;
            }
    }
    echo "<OPTION VALUE=\"calendar.php?cal=Personal\">Personal</OPTION>\n".
         "          </SELECT>\n".
         '          <INPUT TYPE=BUTTON VALUE="' . _("Go") . '" onClick="' .
         'for (i=0;i<document.calswitch.calselect.length;i++){if ' .
         '(document.calswitch.calselect.options[i].selected) ' .
         'dest=document.calswitch.calselect.options[i].value;} ' .
         'location.href=dest;">' . "\n";
    echo "          </FORM></TD></TR>\n".
         "</TABLE></TD></TR></TABLE>\n";
}


if( !isset( $month ) || $month <= 0){
    $month = date( 'm' );
}
if( !isset($year) || $year <= 0){
    $year = date( 'Y' );
}
if( !isset($day) || $day <= 0){
    $day = date( 'd' );
}

$todayis = date( 'mdY' );
$calself=basename($PHP_SELF);

displayPageHeader($color, 'None');
calendar_header();
readcalendardata();
startcalendar();
drawmonthview();
endcalendar();

?>
</body></html>
