<?php

  /*
   *  Secure Login Plugin
   *  By Graham Norbury <gnorbury@bondcar.com>
   *  Changes by Paul Lesneiwski <pdontthink@angrynerds.com>
   *  v1.0 (c) 2002 (GNU GPL - see ../../COPYING)
   *
   *  This is a very simple plugin which enforces use of SSL security for logins.
   *
   *  If you need help with this, or see improvements that can be made, please
   *  email one or both of us directly at the addresses above.
   *
   */


   // include compatibility plugin
   //
   if (defined('SM_PATH'))
      include_once(SM_PATH . 'plugins/compatibility/functions.php');
   else if (file_exists('../plugins/compatibility/functions.php'))
      include_once('../plugins/compatibility/functions.php');
   else if (file_exists('./plugins/compatibility/functions.php'))
      include_once('./plugins/compatibility/functions.php');


   function secure_login_check_do()
   {

      global $secure_login_count, $plugin_secure_login_cameInUsingHttps,
             $allVirtualDomainsUnderOneSSLHost, $securePort;
      
      compatibility_sqextractGlobalVar('secure_login_count');
      if (!isset($secure_login_count))
      {
         $secure_login_count = 0;
         $secure_logoff_count = 0;
         compatibility_sqsession_register($secure_login_count, 'secure_login_count');
         compatibility_sqsession_register($secure_logoff_count, 'secure_logoff_count');
         compatibility_sqsession_unregister('plugin_secure_login_cameInUnencrypted');
      }

      // get global variables for versions of PHP < 4.1
      // 
      if (!compatibility_check_php_version(4, 1)) {
         global $HTTP_SERVER_VARS, $HTTP_GET_VARS;
         $_SERVER = $HTTP_SERVER_VARS;
         $_GET = $HTTP_GET_VARS;
      }

      if (compatibility_check_sm_version(1, 3))
         include_once (SM_PATH . 'plugins/secure_login/config.php');
      else
         include_once ('../plugins/secure_login/config.php');


      // debug functionality
      // 
$debug = 0;      
      if ($debug == 1)
      {  
         echo "<hr>";
         print_r($_SERVER);
         echo "<hr>";
         exit;
      }


      
      // Redirect browser to use https:// if the initial request was insecure
      if ( ! isset($_SERVER['HTTPS']) &&
           $secure_login_count == 0)
      {  

         $secure_login_count++;
         compatibility_sqsession_register($secure_login_count, 'secure_login_count');
         
         $requestHost = $_SERVER['HTTP_HOST'];
         
         if (isset($securePort))
         {
            if (!empty($securePort))
               $securePort = ':' . $securePort;
            
            list($host, $port) = preg_split('/:/', $requestHost);
            $newRequestHost = $host . $securePort;
         }
         else
            $newRequestHost = $requestHost;
          
            
         $location = 'https://' 
                   . $newRequestHost . $_SERVER['REQUEST_URI'] . '?secure_login=yes';
         
         if (!empty($allVirtualDomainsUnderOneSSLHost))
            $location = 'https://' . $allVirtualDomainsUnderOneSSLHost  
                      . $newRequestHost . $_SERVER['REQUEST_URI'] . '?secure_login=yes';
         
         header("Location: $location");
         exit();

      }
      else if (isset($_SERVER['HTTPS'])) 
      {

         if (isset($_GET['secure_login']))
         {
            $plugin_secure_login_cameInUnencrypted = 'yes';
            compatibility_sqsession_register($plugin_secure_login_cameInUnencrypted, 
                                             'plugin_secure_login_cameInUnencrypted');
         }
         elseif (!empty($allVirtualDomainsUnderOneSSLHost) && !$secure_login_count)
         {
            $secure_login_count++;
            compatibility_sqsession_register($secure_login_count, 'secure_login_count');

            $location = 'https://' . $allVirtualDomainsUnderOneSSLHost
                      . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

            header("Location: $location");
            exit();

         }
      }
   }


   // after login, go back to http protocol
   //
   function secure_login_logout_do()
   {

      global $change_back_to_http_after_login, 
             $remain_in_https_if_logged_in_using_https,
             $plugin_secure_login_cameInUnencrypted;

      if (compatibility_check_sm_version(1, 3))
         include_once (SM_PATH . 'plugins/secure_login/config.php');
      else
         include_once ('../plugins/secure_login/config.php');


      if (!$change_back_to_http_after_login)
         return;


      if (!compatibility_sqsession_is_registered('plugin_secure_login_cameInUnencrypted')
          && $remain_in_https_if_logged_in_using_https) 
         return;


      // get global variables for versions of PHP < 4.1
      //
      if (!compatibility_check_php_version(4, 1)) {
         global $HTTP_SERVER_VARS;
         $_SERVER = $HTTP_SERVER_VARS;
      }


      global $secure_logoff_count;
      compatibility_sqextractGlobalVar('secure_logoff_count');
      if (!isset($secure_logoff_count))
      {
         $secure_logoff_count = 0;
         compatibility_sqsession_register($secure_logoff_count, 'secure_logoff_count');
      }


      if ( ! isset($_SERVER['HTTP']) && $secure_logoff_count == 0)
      { 

         $secure_logoff_count++; 
         compatibility_sqsession_register($secure_logoff_count, 'secure_logoff_count'); 
         $location = 'http://' . $_SERVER['HTTP_HOST'] 
            . $_SERVER['PHP_SELF']; 
         displayHtmlHeader('', 
            "\n<META HTTP-EQUIV=\"REFRESH\" CONTENT=\"0;URL=$location\">\n"); 
         exit(); 

      }

   }


?>
