<?php
  /*
   *  Secure Login Plugin
   *  By Graham Norbury <gnorbury@bondcar.com>
   *  v0.2 (c) 2002 (GNU GPL - see ../../COPYING)
   *
   *  This is a very simple plugin which enforces use of SSL security for logins
   *
   *  If you need help with this, or see improvements that can be made, please
   *  email me directly at the address above.
   *
   */

   function squirrelmail_plugin_init_secure_login()
   {
      global $secure_login_count;
      global $squirrelmail_plugin_hooks;

      $secure_login_count = 0;
      session_register('secure_login_count');

      $squirrelmail_plugin_hooks['login_cookie']['secure_login'] = 'secure_login_check';
   }

   function secure_login_check()
   {
      global $secure_login_count;

      // Redirect browser to use https:// if the initial request was insecure
      global $HTTP_SERVER_VARS;
      if ( ! isset($HTTP_SERVER_VARS['HTTPS']) &&
           ! $secure_login_count )
      {
         $secure_login_count++;
         session_register('secure_login_count');

         $location = 'https://' .
                     $HTTP_SERVER_VARS['HTTP_HOST'] .
                     $HTTP_SERVER_VARS['REQUEST_URI'];
         header("Location: $location");
         exit();
      }
   }
?>
