<?php
/**
 * plugins/qmailadmin_login/functions.php -- Functions used by plugin
 *
 * Copyright (c) 2004-2005 Tomas Kuliavas <tokul@users.sourceforge.net>
 * This file is part of SquirrelMail QmailAdmin Login plugin.
 *
 * QmailAdmin Login plugin is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * QmailAdmin Login plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with QmailAdmin Login plugin; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @version $Id: functions.php,v 1.4 2005/06/26 07:10:35 tokul Exp $
 * @package sm-plugins
 * @subpackage qmailadmin_login
 */

/**
 * set SM_PATH, for those who decide to access script directly
 * @ignore
 */
if (!defined('SM_PATH'))  define('SM_PATH','../../');

// load default_config
if (file_exists(SM_PATH . 'plugins/qmailadmin_login/config_default.php')) {
    include_once(SM_PATH . 'plugins/qmailadmin_login/config_default.php');
} else {
    // somebody removed default configuration file
    $qmlogin_cgi_url='/cgi-bin/qmailadmin';
    $qmlogin_frameborder=true;
    $qmlogin_autologin=false;
}

// load config
if (file_exists(SM_PATH . 'config/qmailadmin_login_config.php')) {
    include_once(SM_PATH . 'config/qmailadmin_login_config.php');
} elseif (file_exists(SM_PATH . 'plugins/qmailadmin_login/config.php')) {
    include_once(SM_PATH . 'plugins/qmailadmin_login/config.php');
}

/**
 * Adds plugin's option block
 */
function qmlogin_options_function() {
    global $optpage_blocks;
    bindtextdomain('qmailadmin_login', SM_PATH . 'locale');
    textdomain('qmailadmin_login');
    $optpage_blocks[] = array(
        'name' => _("Account Administration"),
        'url'  => SM_PATH . 'plugins/qmailadmin_login/qmlogin.php',
        'desc' => _("This option provides access to account management interface."),
        'js'   => false
        );
    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');
}

/**
 * Creates login form.
 * @param string $qmlogin_cgi_url cgi
 * @param string $qmlogin_username login name
 * @param string $qmlogin_domain domain
 */
function qmlogin_login_form($qmlogin_cgi_url,$qmlogin_username,$qmlogin_domain) {
    echo '<p>' . _("Please confirm your password in order to access account management pages.") . "</p>\n";

    echo addForm($qmlogin_cgi_url,'post','qmlogin_user');
    echo addHidden('username',$qmlogin_username);
    echo addHidden('domain',$qmlogin_domain);
    echo addHidden('returnhttp','');
    echo addHidden('returntext','');
    echo _("Your password: ") . addPwField('password');
    echo addSubmit('Login',_("Login"));
    echo "</form>";
}
?>