<?php

/**
  * SquirrelMail Multilogin Plugin
  * Copyright (c) 2003-2010 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage multilogin
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_multilogin() {

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['login_form']['multilogin']
      = 'multilogin_insertIMAPSelection';
   $squirrelmail_plugin_hooks['template_construct_login.tpl']['multilogin']
      = 'multilogin_insertIMAPSelection';
   $squirrelmail_plugin_hooks['login_before']['multilogin']
      = 'multilogin_registerIMAPServer';


   // needed as of SM 1.5.2 to re-add settings to session, because
   // SM wipes out session upon login to prevent session hijack
   //
   $squirrelmail_plugin_hooks['login_verified']['multilogin']
      = 'multilogin_registerIMAPServer';


   // as of SM 1.5.2, this hook replaces need for patching the SM source
   // (note that config_override is now called prefs_backend)
   //
   // $squirrelmail_plugin_hooks['config_override']['multilogin'] 
   $squirrelmail_plugin_hooks['prefs_backend']['multilogin'] 
      = 'multilogin_pre_sqoverride_config';


   // configtest
   //
   $squirrelmail_plugin_hooks['configtest']['multilogin']
      = 'multilogin_check_configuration';

}



/**
  * Returns info about this plugin
  *
  */
function multilogin_info()
{

   return array(
                 'english_name' => 'Multilogin',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '2.4.1',
                 'required_sm_version' => '1.2.9',
                 'requires_configuration' => 1,
                 'summary' => 'Allows manual selection of login server on login page.',
                 'details' => 'This plugin displays a pull-down select box with IMAP server choices on the login page.  The user will be logged in using the IMAP server that is chosen.<br /><br />Any number of SquirrelMail configuration settings may be changed for each server that is offered to the user, including IMAP server details, what plugins are activated, and any other settings found in the main SquirrelMail configuration file.',
                 'required_plugins' => array(
                    'compatibility' => array(
                       'version' => '2.0.12',
                       'activate' => FALSE,
                    )
                 ),
                 'per_version_requirements' => array(
                    '1.5.2' => array(
                       'requires_source_patch' => 0,
                    ),
                    '1.2.9' => array(
                       'requires_source_patch' => 1,
                    ),
                 ),
               );

}



/**
  * Returns version info about this plugin
  *
  */
function multilogin_version()
{

   $info = multilogin_info();
   return $info['version'];

}



/**
  * store the user's IMAP server in the session
  *
  */
function multilogin_registerIMAPServer($args='')
{

   include_once(SM_PATH . 'plugins/multilogin/functions.php');
   multilogin_registerIMAPServer_do($args);

}


/**
  * present IMAP server selection pull-down
  *
  */
function multilogin_insertIMAPSelection()
{

   include_once(SM_PATH . 'plugins/multilogin/functions.php');
   return multilogin_insertIMAPSelection_do();

}



/**
  * replace global SM config values with overrides
  *
  */
function multilogin_pre_sqoverride_config($args='')
{

   include_once(SM_PATH . 'plugins/multilogin/functions.php');
   multilogin_pre_sqoverride_config_do($args);

}



/**
  * Validate that this plugin is configured correctly
  *
  */
function multilogin_check_configuration()
{

   include_once(SM_PATH . 'plugins/multilogin/functions.php');
   return multilogin_check_configuration_do();
 
}



