<?php

/**
  * SquirrelMail Multilogin Plugin
  * Copyright (c) 2003-2007 Paul Lesneiwski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage multilogin
  *
  */


/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_multilogin() {

   global $squirrelmail_plugin_hooks;

   $squirrelmail_plugin_hooks['login_form']['multilogin']
      = 'multilogin_insertIMAPSelection';
   $squirrelmail_plugin_hooks['template_construct_login.tpl']['multilogin']
      = 'multilogin_insertIMAPSelection';
   $squirrelmail_plugin_hooks['login_before']['multilogin']
      = 'multilogin_registerIMAPServer';


   // needed as of SM 1.5.2 to re-add settings to session, because
   // SM wipes out session upon login to prevent session hijack
   //
   $squirrelmail_plugin_hooks['login_verified']['multilogin']
      = 'multilogin_registerIMAPServer';


   // unfortunately, we can only set org_title in the title
   // bar of the browser if we use this hook - otherwise, it's
   // unecessary
   //
   $squirrelmail_plugin_hooks['webmail_top']['multilogin']
      = 'multilogin_sqoverride_config';


   // as of SM 1.5.2, this hook replaces need for patching the SM source
   //
   $squirrelmail_plugin_hooks['config_override']['multilogin'] 
      = 'multilogin_sqoverride_config';

}



/** @ignore */
if (!defined('SM_PATH'))
   define('SM_PATH', '../');



/**
  * Returns info about this plugin
  *
  */
function multilogin_info()
{

   return array(
                 'english_name' => 'MultiLogin',
                 'version' => '2.3.3',
                 'required_sm_version' => '1.2.9',
                 'requires_configuration' => 1,
                 'requires_source_patch' => 2,
                 'required_plugins' => array(
                                               'compatibility' => '2.0.5',
                                            ),
                 'summary' => 'Allows manual selection of login server on login page.',
                 'details' => 'This plugin displays a pull-down select box with IMAP server choices on the login page. The user will be logged in using the IMAP server that is chosen.',
               );

}



/**
  * Returns version info about this plugin
  *
  */
function multilogin_version()
{

   $info = multilogin_info();
   return $info['version'];

}



/**
  * store the user's IMAP server in the session
  *
  */
function multilogin_registerIMAPServer($args='')
{

   include_once(SM_PATH . 'plugins/multilogin/functions.php');
   multilogin_registerIMAPServer_do($args);

}


/**
  * present IMAP server selection pull-down
  *
  */
function multilogin_insertIMAPSelection()
{

   include_once(SM_PATH . 'plugins/multilogin/functions.php');
   return multilogin_insertIMAPSelection_do();

}



/**
  * replace global SM config values with overrides
  *
  */
function multilogin_sqoverride_config($args='')
{

   include_once(SM_PATH . 'plugins/multilogin/functions.php');
   multilogin_sqoverride_config_do($args);

}



