<?php

/**
  * SquirrelMail Login Check Plugin
  * Copyright (c) 2009-2010 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage login_check
  *
  */



/**
  * Initialize this plugin (load config values)
  *
  * @return boolean FALSE if no configuration file could be loaded, TRUE otherwise
  *
  */
function login_check_init()
{

   if (!@include_once (SM_PATH . 'config/config_login_check.php'))
      if (!@include_once (SM_PATH . 'plugins/login_check/config.php'))
         if (!@include_once (SM_PATH . 'plugins/login_check/config_default.php'))
            return FALSE;

   return TRUE;

}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function login_check_check_configuration()
{

   // make sure base config is available
   //
   if (!login_check_init())
   {
      do_err('Login Check plugin is missing its main configuration file', FALSE);
      return TRUE;
   }

}



/**
  * If needed, display message on login page
  *
  */
function login_check_warning()
{
   global $lc_show_login_warning;
   if ($lc_show_login_warning)
   {
//TODO: in 1.5.2, this will probably be different
      sq_change_text_domain('login_check');
      echo '<br /><center><strong>' . _("WARNING! There is already a user logged in, probably in another browser tab or window. Please make sure to close that tab or window.") . '</strong></center><br />';
      sq_change_text_domain('squirrelmail');
   }
}



/**
  * Check that there are no other users
  * logged in when loading the login page
  *
TODO: this is NOT currently true, since this plugin does not yet support 1.5.2 (there isn't a hook where we need one)
  * Note that this function gets executed twice under
  * 1.4.x because the prefs_backend hook registration
  * that is required for 1.5.2.  This currently does
  * not cause any problems, so we won't do anything
  * about it
  *
  */
function login_check()
{

   // only operate on the login page
   //
   global $PHP_SELF;
   if (strpos($PHP_SELF, '/src/login.php') === FALSE) return;


   global $login_check_method;
   login_check_init();
   

   if (sqsession_is_registered('user_is_logged_in'))
   {

      // this is of no use, because the OTHER window where
      // the original login is needs to be closed!
      //
      //header('Location: signout.php');


      // refuse any more logins until other account is signed out
      // 
      if ($login_check_method == 1)
      {
//TODO: in 1.5.2, this will probably be different
         global $color;
         include_once(SM_PATH . 'functions/display_messages.php');
         include_once(SM_PATH . 'functions/prefs.php');
         sq_change_text_domain('login_check');
         error_box(_("There is already a user logged in, probably in another browser tab or window. Please log out of that account first."), $color);
         exit;
      }

      // just warn the user
      //
      else if ($login_check_method == 2)
      {
         global $lc_show_login_warning;
         $lc_show_login_warning = 1;
         // the rest is done in the login_top hook
      }

      // simply show the current login account
      //
      else if ($login_check_method == 3)
      {
         header('Location: webmail.php');
         exit;
      }


   }

}



