<?php
   /*
    *  Login:Auto Plugin
    *  By Jay Guerette <JayGuerette@pobox.com>
    *  (c) 2001 (GNU GPL - see ../../COPYING)
    *
    *  If you need help with this, or see improvements that can be made, please
    *  email me directly at the address above.  I definately welcome suggestions
    *  and comments.  This plugin, as is the case with all SquirrelMail plugins,
    *  is not directly supported by the developers.  Please come to me off the
    *  mailing list if you have trouble with it.
    *
    *  View the README document for information on installing this.  Also view
    *  plugins/README.plugins for more information.
    *
    */

   function squirrelmail_plugin_init_login_auto() {
      global $squirrelmail_plugin_hooks;

      $squirrelmail_plugin_hooks['login_cookie']['login_auto'] = 'login_auto_get_user';
      $squirrelmail_plugin_hooks['login_form']['login_auto'] = 'login_auto_set_login';
      $squirrelmail_plugin_hooks['login_before']['login_auto'] = 'login_auto_get_pass';
      $squirrelmail_plugin_hooks['login_verified']['login_auto'] = 'login_auto_set_cookies';
      $squirrelmail_plugin_hooks['logout']['login_auto'] = 'login_auto_clear_cookies';
   }

   // called in login.php
   function login_auto_get_user() {
	global $login_username;
	global $secretkey;
	global $just_logged_in;
	global $base_uri;
	global $user;
	global $pass;

	require ('../plugins/login_auto/login_auto_config.php');

   	if (!$auto_pass) setcookie('pass', '', time()-3600, $base_uri);
   	if (!$auto_user) setcookie('user', '', time()-3600, $base_uri);
   	if ($auto_user && (isset($user) && $user)) {
		$login_username=MD5Decrypt(base64_decode($user),$auto_key);
		if ($auto_pass && (isset($pass) && $pass)) {
			header("Location: redirect.php?login_username=$login_username");
		}
	   }
   }

   // called in login.php
   function login_auto_set_login() {
	global $username_form_name;
	global $login_username;

	require ('../plugins/login_auto/login_auto_config.php');

	if ($auto_pass) {
		echo "<table border=0><tr><td valign=center>\n";
		echo "<input type=checkbox name=cb_auto_pass value=true>\n";
		echo "</td><td valign=center nowrap>\n";
		echo "<small>Remember my Name & Password<small>\n";
		echo "</td></tr></table>\n";
	}
	else {
		if ($auto_user && !isset($user)) {
			echo "<table border=0><tr><td valign=center>\n";
			echo "<input type=checkbox name=cb_auto_user value=true>\n";
			echo "</td><td valign=center nowrap>\n";
			echo "<small>Remember my Name</small>\n";
			echo "</td></tr></table>\n";
		}
	}
	if (($auto_user || $auto_pass) && $login_doc!='') {
		if (!isset($login_link) || $login_link=='') $login_link='read this note about security';
		echo "<a href=$login_doc>$login_link</a>\n";
	}
	if ($auto_user && $login_username) {
		echo "<script language=javascript>\ndocument.f.$username_form_name.value=\"$login_username\";\n";
		echo "document.f.cb_auto_user.checked=true;\n</script>\n";
	}
   }

   // called in redirect.php
   function login_auto_get_pass() {
	global $secretkey;
	global $just_logged_in;
	global $user;
	global $pass;

	require ('../plugins/login_auto/login_auto_config.php');

	if ($auto_pass && isset($pass) && isset($user)) {
		$secretkey=MD5Decrypt(base64_decode($pass),$auto_key);
	   	$just_logged_in=1;
	}

	login_auto_clear_cookies();
   }

   // called in redirect.php
   function login_auto_set_cookies() {
	global $cb_auto_user;
	global $cb_auto_pass;
	global $login_username;
	global $secretkey;
	global $base_uri;
	global $user;
	global $pass;

	require ('../plugins/login_auto/login_auto_config.php');

	if ($auto_user && !$auto_pass && !isset($cb_auto_user)) return;

	if ((isset($cb_auto_user) && $cb_auto_user) || (isset($cb_auto_pass) && $cb_auto_pass) ||
		($auto_user && ($user || $login_user)) || ($auto_pass && $pass)) {
		setcookie('user', base64_encode(MD5Encrypt($login_username,$auto_key)), time()+$auto_expire, $base_uri);
	}
	if ((isset($cb_auto_pass) && $cb_auto_pass) || ($auto_pass && $pass && $user)) {
		setcookie('pass', base64_encode(MD5Encrypt($secretkey,$auto_key)), time()+$auto_expire, $base_uri);
	}
   }

   // called in signout.php
   function login_auto_clear_cookies() {
	global $base_uri;

	setcookie('user', '', time()-3600, $base_uri);
	setcookie('pass', '', time()-3600, $base_uri);
   }

   /*
    * The algorithm is a double XOR. MD5Encrypt XORs the plaintext with a random number.
    * The number is interleaved with the XOR output so it can retreived for decryption.
    * MD5Keycrypt XORs this string with your encryption key. Techincally, MD5 is not used
    * for the actual encryption, just to stengthen it.
    *
    */

   function MD5Keycrypt($txt,$key) 
   { 
	for ($i=0,$j=0,$val='',$key=md5($key),$keylen=strlen($key),$txtlen=strlen($txt);$i<$txtlen;$i++) {
		$val.=substr($txt,$i,1)^substr($key,($j==$keylen)?$j*=0:$j++,1);
	} 
	return $val; 
   } 

   function MD5Encrypt($txt,$key) 
   { 
	if (is_array($key)) {
		for ($i=0,$alen=sizeof($key);$i<$alen;$i++) {
			$txt=($i%2)?MD5Encrypt($txt,$key[$i]):MD5Keycrypt($txt,$key[$i]);
		}
		return $txt;
	}
	srand((double)microtime()*1000000); 
	$cryptkey=md5(rand(0,32000));
	for ($i=0,$j=0,$val='',$keylen=strlen($cryptkey),$txtlen=strlen($txt);$i<$txtlen;$i++) {
		$val.=substr($cryptkey,$j,1).(substr($txt,$i,1)^substr($cryptkey,($j==$keylen)?$j*=0:$j++,1));
	} 
	return MD5Keycrypt($val,$key); 
   } 

   function MD5Decrypt($txt,$key) 
   { 
	if (is_array($key)) {
		for ($i=sizeof($key)-1;$i>=0;$i--) {
			$txt=($i%2)?MD5Decrypt($txt,$key[$i]):MD5Keycrypt($txt,$key[$i]);
		}
		return $txt;
	}
	for ($i=0,$val='',$txt=MD5Keycrypt($txt,$key),$txtlen=strlen($txt);$i<$txtlen;$i++) {
		$val.=(substr($txt,$i+1,1)^substr($txt,$i++,1));
	} 
	return $val; 
   } 

?>
