<?php

/**
  * SquirrelMail Empty Trash Plugin
  *
  * Copyright (c) 2004-2011 Paul Lesniewski <paul@squirrelmail.org>
  * Copyright (c) 2002-2003 Derek Battams <derek@battams.ca>
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage empty_trash
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_empty_trash()
{

   global $squirrelmail_plugin_hooks;


   // Increment a counter each time a user signs into SquirrelMail
   //
   $squirrelmail_plugin_hooks['login_verified']['empty_trash']
      = 'empty_trash_counter_increment_stub';


   // Decide if it's time to delete the user's
   // trash folder and if it is then do it!
   //
   $squirrelmail_plugin_hooks['left_main_before']['empty_trash']
      = 'check_empty_trash_stub';


   // Empty trash folder upon logout if needed
   //
   $squirrelmail_plugin_hooks['logout']['empty_trash']
      = 'empty_trash_on_logout_stub';

}



/**
  * Returns info about this plugin
  *
  */
function empty_trash_info()
{

   return array(
                  'english_name' => 'Empty Trash',
                  'authors' => array(
                     'Paul Lesniewski' => array(
                        'email' => 'paul@squirrelmail.org',
                        'sm_site_username' => 'pdontthink',
                     ),
                     'Derek Battams' => array(
                        'email' => 'derek@battams.ca',
                     ),
                  ),
                  'version' => '2.0',
                  'required_sm_version' => '1.2.2',
                  'requires_configuration' => 0,
                  'summary' => 'Automatically empties users\' trash folders periodically.',
                  'details' => 'This plugin automatically empty users\' trash folders periodically.  The system administrator can configure the trash to be emptied for users based on number of logins or number of days since last login, and have the trash emptied either upon login or logout.',
                  'requires_source_patch' => 0,
                  'required_plugins' => array(),
               );

}



/**
  * Returns version info about this plugin
  *
  */
function empty_trash_version()
{
   $info = empty_trash_info();
   return $info['version'];
}



/** 
  * Increment a counter each time a user signs into SquirrelMail
  *
  */
function empty_trash_counter_increment_stub()
{
   include_once(SM_PATH . 'plugins/empty_trash/functions.php');
   empty_trash_counter_increment();
}



/**
  * Decide if it's time to delete the user's
  * trash folder and if it is then do it!
  *
  */
function check_empty_trash_stub()
{
   include_once(SM_PATH . 'plugins/empty_trash/functions.php');
   check_empty_trash();
}



/**
  * Empty trash folder upon logout if needed
  *
  */
function empty_trash_on_logout_stub()
{
   include_once(SM_PATH . 'plugins/empty_trash/functions.php');
   empty_trash_on_logout();
}



