(* 
 * Copyright (c) 2000 Carnegie Mellon University.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The name "Carnegie Mellon University" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For permission or any other legal
 *    details, please contact  
 *	Office of Technology Transfer
 *	Carnegie Mellon University
 *	5000 Forbes Avenue
 *	Pittsburgh, PA  15213-3890
 *	(412) 268-4387, fax: (412) 268-7395
 *	tech-transfer@andrew.cmu.edu
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Computing Services
 *     at Carnegie Mellon University (http://www.cmu.edu/computing/)."
 *
 * CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *)

structure Absyn = struct

  type pos = int
    
  structure V = Value
    
  datatype line =
    Line of string * command
  | Error of string option * string
  | BareString of string

  and command =
      DeleteAcl of aclobj * string option
    | DeletedSince of string * string
    | FreeContext of string
    | UpdateContext of string list
    | GetQuota of string
    | Lang of string list
    | ListRights of aclobj * string
    | MyRights of aclobj
    | Search of string * searchmod list * searchcrit
    | SetAcl of aclobj * string * string
    | Store of storeentry list
    | Noop
    | Logout
    | Authenticate of string * string option

  and aclobj = 
      AclObj of string * string option * string option

  and searchmod =
      Depth of int
    | HardLimit of int
    | Limit of int * int
    | MakeContext of bool * bool * string
    | Return of metadata list
    | Sort of sortitem list
    | Noinherit
      
  and metadata =
      MetaData of string * string list

  and sortitem =
      SortItem of string * comparator

  and comparator =
      Comparator of string

  and searchcrit =
      All
    | Equal of string * comparator * V.value
    | Compare of string * comparator * V.value
    | Prefix of string * comparator * V.value
    | Range of int * int * string
    | Strict of string * comparator * V.value
    | Substr of string * comparator * V.value
    | Not of searchcrit
    | Or of searchcrit * searchcrit
    | And of searchcrit * searchcrit

  and storeentry =
      StoreEntry of string * storemod list * attrstore list

  and storemod =
      NoCreate
    | UnchangedSince of string

  and attrstore =
      AttrStoreValue of string * V.value
    | AttrStoreMeta of string * (string * V.value) list

end
