(* stolen from RWH's 15-312 *)

signature SOCKET_STREAMS =
sig

  val create : ('a,Socket.active Socket.stream) Socket.sock
               * unit SyncVar.ivar
               -> string CML.chan * string CML.chan

  val acceptLoop : ('a,Socket.passive Socket.stream) Socket.sock
                   * unit SyncVar.ivar
                   -> (('a,Socket.active Socket.stream) Socket.sock
                       * 'a Socket.sock_addr) CML.chan

  val inet_port_socket : int -> (INetSock.inet,Socket.passive Socket.stream) Socket.sock

  val unix_socket : string -> (UnixSock.unix, Socket.passive Socket.stream) Socket.sock

end

structure SocketStreams :> SOCKET_STREAMS =
struct

  open CML

  fun addNewCleaner(n,f) =
      case RunCML.addCleaner(n,[RunCML.AtExit,RunCML.AtShutdown],f)
        of SOME(w,f') => (RunCML.addCleaner(n,w,f');
                          addNewCleaner(n ^ "'",f))
         | NONE => ()

  fun inet_port_socket(port) =
      let val socket = INetSock.TCP.socket()
          val addr = INetSock.any port;
       in Socket.bind(socket, addr);
	  Socket.Ctl.setREUSEADDR(socket, true);
          (* addNewCleaner("CleanListenSocket",fn _ => Socket.close(socket));*)
          Socket.listen(socket, 20);
          socket
      end

  fun unix_socket address =
    let 
      val socket = UnixSock.Strm.socket ()
      val addr = UnixSock.toAddr address
      val _ = ((Posix.FileSys.unlink address) handle _ => ())
    in
      Socket.bind(socket, addr);
      Socket.Ctl.setREUSEADDR(socket, true);
      Socket.listen(socket, 20);
      socket
    end

  fun acceptLoop(socket,pleaseDie) =
      let val ch = channel()

          val acceptE = wrap(OS.IO.pollEvt
                             [OS.IO.pollIn(Socket.pollDesc socket)],
                             fn _ => Socket.accept(socket))
	  val dieE = SyncVar.iGetEvt pleaseDie
          fun acc() =
	    (CML.send (ch, select[acceptE, wrap(dieE, cleanup)]);
	     acc())

          and cleanup() = (TextIO.print "accept loop stopped...\n";
			   Socket.close(socket);
			   CML.exit ())

       in TextIO.print "accept loop started...\n";
          addNewCleaner("CleanAcceptLoop",
                        fn _ => SyncVar.iPut(pleaseDie,()) handle _ => ());
          spawn(acc);
          ch
      end

  fun create(socket,pleaseDie) =
      let val inch = channel()
          val outch = channel()

          fun cleanup() = (TextIO.print "remote connection closed...\n";
                           Socket.close(socket);
			   CML.exit ())

	  val inEvts = [Socket.recvVecEvt(socket,1024),
			wrap(SyncVar.iGetEvt pleaseDie, cleanup)]

          fun readLoop() =
	    let
	      (* val _ = TextIO.print "Here i am\n" *)
              val v = select inEvts
	      (* val _ = TextIO.print "read something\n" *)
	    in if Word8Vector.length v = 0 then cleanup ()
	       else (send(inch,Byte.bytesToString(v));
		     readLoop())
	    end

          fun doout(v,i) =
	    (if i <> 0 andalso i <> Word8Vector.length(v) then 
	       TextIO.print ("out: " ^ (Int.toString i) ^ "\n")
	     else ();
	     if i < Word8Vector.length(v)
                then doout(v,i+Socket.sendVec(socket,{buf=v,i=i,sz=NONE}))
              else ())

	  (* handle exceptions *)
          fun writeLoop() =
              (doout(Byte.stringToBytes(recv(outch)),0);
               writeLoop())

      in TextIO.print "remote connection opened...\n";
         addNewCleaner("CleanSocketReader",
                       fn _ => SyncVar.iPut(pleaseDie,()) handle _ => ());
         spawn(readLoop);
         spawn(writeLoop);
         (inch,outch)
      end

end
