signature SASL =
sig
  type conn

  val init : unit -> unit

  val newconn : unit -> conn

  val listmechs : conn -> string

  (* returns NONE on failure, SOME name on success *)
  val doauth : 
    conn -> (string * string * string option) -> ((unit -> string option) 
					   * Response.response CML.chan)
    -> string option
    
  val doneconn : conn -> unit

  val done : unit -> unit
end
