signature PARSE =
sig
  val create : (string CML.chan * Execute.conn) -> CML.thread_id
end

structure Parse :> PARSE =
struct
  structure AcapLrVals = AcapLrValsFun(structure Token = LrParser.Token)
  structure Lex = AcapLexFun(structure Tokens = AcapLrVals.Tokens)
  structure AcapP = Join(structure ParserData = AcapLrVals.ParserData
			 structure Lex = Lex
			 structure LrParser = LrParser)

  fun exnerror exn =
    String.concat ["Serious internal error: ",
		   (exnMessage exn),
		   " history: ",
		   (foldr (fn (s, acc) => (acc ^ s ^ ";")) "" 
		           (SMLofNJ.exnHistory exn))]

  fun create (inch, conn) =
    let 
      fun get _ = CML.recv inch
      val myerror = ref ""
      fun parseerror (s, p1, p2) = (myerror := s)
      val lexer = AcapP.makeLexer get
      val dummyEOF = AcapLrVals.Tokens.EOF(0,0)
      val dummyCRLF = AcapLrVals.Tokens.CRLF(0,0)

      fun errorAdvance (nextToken, lexer) =
	if AcapP.sameToken(nextToken, dummyCRLF) orelse
	  AcapP.sameToken(nextToken, dummyEOF) then (nextToken, lexer)
	else (* we want to advance the lexer until we get there *)
	   errorAdvance (AcapP.Stream.get lexer)

      fun doauth (conn, lexer, (saslconn, tag, mech, first, response)) =
	let
	  val lexr = ref lexer

	  fun getstring (Absyn.BareString s) = SOME s
	    | getstring _ = NONE

	  fun get () =
	    let val (absyn, lexer) = (AcapP.parse(0, !lexr, parseerror, ()))
	        val (nextToken, lexer) = AcapP.Stream.get lexer
		val (nextToken, lexer) = errorAdvance (nextToken, lexer)
	    in lexr := lexer;
	      getstring absyn
	    end
	in case 
	  Sasl.doauth saslconn (tag, mech, first) (get, response)
	  of (SOME user) => (Execute.authAs conn 
			          (Auth.fromString user), !lexr)
           | NONE => (conn, !lexr)
	end

      fun (*getTag (AcapLrVals.ParserData.Token.TOKEN 
		   (_, AcapLrVals.Token.TAG s)) = SOME s
	| *)getTag _ = NONE

      fun loop lexer conn = 
	(let
	   val _ = print "ready to parse line...\n"

	   val (absyn, lexer) = (AcapP.parse(0, lexer, parseerror, ())
				 handle AcapP.ParseError =>
				   let
				     val (tok, _) = AcapP.Stream.get lexer
				   in
				    (Absyn.Error (getTag tok, !myerror), lexer)
				   end
				      | Lex.LexError =>
				   (Absyn.Error (NONE, "unrecognized token"),
				    lexer))

	   (* get the character that ended our parse *)
	   val (nextToken, lexer) = AcapP.Stream.get lexer

	   val (nextToken, lexer) = errorAdvance(nextToken, lexer)

	   val (conn, lexer) = 
	     if AcapP.sameToken(nextToken, dummyEOF) then
	       (Execute.stop conn; CML.exit ())
	     else (Execute.run conn absyn, lexer)
	       handle Execute.CloseConnection =>
		 (print "user logged out\n";
		  Execute.stop conn;
		  CML.exit ())
		    | Execute.doAuth stuff => 
		 doauth (conn, lexer, stuff)
		    | exn => 
		 (print "caught exception...\n";
		  print ((exnMessage exn) ^ "\n");
		  Execute.error conn (exnerror exn);
		  CML.exit ())
	 in
	   loop lexer conn
	 end
	   handle e => print ((exnMessage e) ^ "\n"))
    in
      print "spawning parser...\n";
      CML.spawn (fn () => loop lexer conn)
    end
end
