signature MESSAGE =
sig
  exception AbortSearch
    
  (* messages from threads to contexts *)
  datatype msg =
  | DELETECONTEXT
  | UPDATECONTEXT
  | SEARCH of ((int option * Entry.entry) -> bool) * 
               Entry.entry Throttle.throttle

  (* messages from contexts *)
  datatype msg' = 
    CNEW of Entry.entry * int option
  | CCHANGE of Entry.entry * (int * int) option
  | CDELETE of Entry.entry * int option
  | CDIE
end
