structure LSyncVar :> LSYNCVAR =
struct
  exception Put = SyncVar.Put

  exception DeadLock

  val tick = Time.fromSeconds 10

  type 'a ivar = 'a SyncVar.ivar

  (* val iVar : unit -> 'a ivar *)
  val iVar = SyncVar.iVar

  (* val iPut : ('a ivar * 'a) -> unit *)
  val iPut = SyncVar.iPut

  (* val iGet : 'a ivar -> 'a *)
  val iGet = SyncVar.iGet

  (* val iGetEvt : 'a ivar -> 'a event *)
  val iGetEvt = SyncVar.iGetEvt

  (* val iGetPoll : 'a ivar -> 'a option *)
  val iGetPoll = SyncVar.iGetPoll

  (* val sameIVar : ('a ivar * 'a ivar) -> bool *)
  val sameIVar = SyncVar.sameIVar

  type 'a mvar = 'a SyncVar.mvar

  (* val mVar : unit -> 'a mvar *)
  val mVar = SyncVar.mVar
    
  (* val mVarInit : 'a -> 'a mvar *)
  val mVarInit = SyncVar.mVarInit

  (* val mPut : ('a mvar * 'a) -> 'a mvar *)
  val mPut = SyncVar.mPut

  fun timeout () = CML.wrap (CML.timeOutEvt tick,
			     (fn () => raise DeadLock))

  (* val mTake: 'a mvar -> 'a *)
  fun mTake m = 
    let
      (* poll first? *)
      val evt = SyncVar.mTakeEvt m
    in
      CML.select [evt, timeout ()]
    end
      
  (* val mTakeEvt : 'a mvar -> 'a event *)
  fun mTakeEvt m = CML.choose [SyncVar.mTakeEvt m, timeout ()]

  (* val mGet : 'a mvar -> 'a *)
  fun mGet m = 
    let
      (* poll first? *)
      val evt = SyncVar.mGetEvt m
    in
      CML.select [evt, timeout ()]
    end
    
  (* val mGetEvt : 'a mvar -> 'a event *)
  fun mGetEvt m = CML.choose [SyncVar.mGetEvt m, timeout ()]

  (* val mTakePoll : 'a mvar -> 'a option *)
  val mTakePoll = SyncVar.mTakePoll

  (* val mGetPoll : 'a mvar -> 'a option *)
  val mGetPoll = SyncVar.mGetPoll

  (* val mSwap : ('a mvar * 'a) -> 'a  *)
  fun mSwap (m, a) =
    let
      val evt = SyncVar.mSwapEvt (m, a)
    in
      CML.select [evt, timeout ()]
    end

  (* val mSwapEvt : ('a mvar * 'a) -> 'a event *)
  fun mSwapEvt m = CML.choose [SyncVar.mSwapEvt m, timeout ()]

  (* val sameMVar : ('a mvar * 'a mvar) -> bool *)
  val sameMVar = SyncVar.sameMVar

end
