signature LSYNCVAR =
sig
  exception Put

  exception DeadLock

  type 'a ivar
  val iVar : unit -> 'a ivar 
  val iPut : ('a ivar * 'a) -> unit 
  val iGet : 'a ivar -> 'a 
  val iGetEvt : 'a ivar -> 'a CML.event 
  val iGetPoll : 'a ivar -> 'a option 
  val sameIVar : ('a ivar * 'a ivar) -> bool 

  type 'a mvar

  val mVar : unit -> 'a mvar
    
  val mVarInit : 'a -> 'a mvar

  val mPut : ('a mvar * 'a) -> unit

  val mTake: 'a mvar -> 'a
      
  val mTakeEvt : 'a mvar -> 'a CML.event

  val mGet : 'a mvar -> 'a
    
  val mGetEvt : 'a mvar -> 'a CML.event

  val mTakePoll : 'a mvar -> 'a option

  val mGetPoll : 'a mvar -> 'a option

  val mSwap : ('a mvar * 'a) -> 'a 
  
  val mSwapEvt : ('a mvar * 'a) -> 'a CML.event 
  
  val sameMVar : ('a mvar * 'a mvar) -> bool 
end
