signature EXECUTE =
sig
  type conn
  
  exception CloseConnection
  exception doAuth of Sasl.conn * string * string * string option 
                                * Response.response CML.chan

  val start : Response.response CML.chan -> Sasl.conn -> conn

  (* process a single line *)
  val run : conn -> Absyn.line -> conn

  (* authenticate as the user *)
  val authAs : conn -> Auth.ident -> conn
    
  (* yikes, something has gone disasterously wrong *)
  val error : conn -> string -> conn

  (* to clean up contexts, etc. *)
  val stop : conn -> unit

end
