(* enumerated sets; given an order function, these will return the placement
   of the elements inserted/removed in the ordered set;
   placement is 1-based, darn it *)
signature ENUM =
sig
  type 'a enum
  type 'a sort = 'a * 'a -> order

  val empty : 'a sort -> 'a enum

  val numItems : 'a enum -> int
  val isEmpty : 'a enum -> bool

  val insert : ('a enum * 'a) -> ('a enum * int)

  val remove : ('a enum * 'a) -> ('a enum * int)

  val app : ('a * int -> unit) -> 'a enum -> unit

end
