structure RMulticast :> RMULTICAST =
struct
  (* uses referencing counting; another implementation would be to use weak
   pointers *)
  structure MC = Multicast

  type 'a event = 'a CML.event 
  type 'a mchan = 'a MC.mchan * int SyncVar.mvar
  type 'a port = 'a MC.port * int SyncVar.mvar

  (* val mChannel : unit -> 'a mchan *)
  fun mChannel () = (MC.mChannel (), SyncVar.mVarInit 0)

  fun inc count =
    let
      val c = SyncVar.mTake count
      val _ = SyncVar.mPut (count, c + 1)
    in
      count
    end

  fun dec count =
    let
      val c = SyncVar.mTake count
      val _ = SyncVar.mPut (count, c - 1)
    in
      count
    end

  (* val port : 'a mchan -> 'a port *)
  fun port (chan, count) = (MC.port chan, inc count)

  (* val copy : 'a port -> 'a port *)
  fun copy (port, count) = (MC.copy port, inc count)

  (* val recv : 'a port -> 'a *)
  fun recv (port, _) = MC.recv port

  (* val recvEvt : 'a port -> 'a event  *)
  fun recvEvt (port, _) = MC.recvEvt port

  (* val multicast : ('a mchan * 'a) -> unit *)
  fun multicast ((chan, _), x) = MC.multicast (chan, x)

  (* val release : 'a port -> unit *)
  fun release (_, count) = ignore (dec count)

  (* val listeners : 'a mchan -> int *)
  fun listeners (chan, count) = SyncVar.mGet count

end
