signature AUTH =
sig
  type ident

  val admins : string

  val master : ident (* used for internal system purposes *)

  (* are the two idents equal? *)
  val equal : ident * ident -> bool

  (* convert a username to an ident *)
  val fromString : string -> ident

  val toString : ident -> string

  (* test if IDENT is a member of STRING *)
  val memberof : (ident * string) -> bool
end
