functor AcapLrValsFun(structure Token : TOKEN)
 : sig structure ParserData : PARSER_DATA
       structure Tokens : Acap_TOKENS
   end
 = 
struct
structure ParserData=
struct
structure Header = 
struct
(* ACAP parser *)
(* Larry Greenfield (leg@andrew.cmu.edu) *)

structure A = Absyn
structure V = Value


end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\001\000\000\000\045\000\000\000\000\000\
\\001\000\002\000\020\000\003\000\019\000\004\000\018\000\005\000\017\000\
\\006\000\016\000\007\000\015\000\008\000\014\000\009\000\013\000\
\\010\000\012\000\011\000\011\000\012\000\010\000\013\000\009\000\
\\014\000\008\000\015\000\007\000\000\000\
\\001\000\016\000\096\000\017\000\095\000\018\000\094\000\019\000\093\000\
\\020\000\092\000\021\000\091\000\022\000\090\000\023\000\089\000\
\\024\000\088\000\025\000\087\000\026\000\086\000\027\000\085\000\
\\028\000\084\000\031\000\083\000\032\000\082\000\033\000\081\000\
\\034\000\080\000\000\000\
\\001\000\016\000\096\000\017\000\095\000\018\000\094\000\019\000\093\000\
\\020\000\092\000\021\000\091\000\031\000\083\000\032\000\082\000\
\\033\000\081\000\034\000\080\000\000\000\
\\001\000\029\000\148\000\030\000\147\000\037\000\037\000\000\000\
\\001\000\029\000\200\000\037\000\037\000\000\000\
\\001\000\035\000\111\000\036\000\110\000\037\000\109\000\000\000\
\\001\000\037\000\004\000\039\000\003\000\000\000\
\\001\000\037\000\037\000\000\000\
\\001\000\037\000\043\000\000\000\
\\001\000\037\000\048\000\000\000\
\\001\000\037\000\050\000\000\000\
\\001\000\037\000\054\000\000\000\
\\001\000\037\000\058\000\000\000\
\\001\000\037\000\073\000\000\000\
\\001\000\037\000\097\000\000\000\
\\001\000\037\000\099\000\000\000\
\\001\000\037\000\101\000\000\000\
\\001\000\037\000\109\000\000\000\
\\001\000\037\000\136\000\000\000\
\\001\000\037\000\164\000\000\000\
\\001\000\037\000\164\000\040\000\163\000\041\000\162\000\042\000\161\000\000\000\
\\001\000\037\000\164\000\040\000\163\000\041\000\162\000\042\000\229\000\000\000\
\\001\000\037\000\164\000\041\000\162\000\000\000\
\\001\000\037\000\167\000\000\000\
\\001\000\037\000\189\000\000\000\
\\001\000\037\000\204\000\000\000\
\\001\000\037\000\218\000\000\000\
\\001\000\037\000\242\000\043\000\241\000\000\000\
\\001\000\037\000\248\000\000\000\
\\001\000\038\000\149\000\000\000\
\\001\000\038\000\150\000\000\000\
\\001\000\038\000\151\000\000\000\
\\001\000\038\000\154\000\000\000\
\\001\000\038\000\202\000\000\000\
\\001\000\038\000\206\000\000\000\
\\001\000\042\000\040\000\000\000\
\\001\000\042\000\042\000\000\000\
\\001\000\042\000\144\000\000\000\
\\001\000\042\000\145\000\000\000\
\\001\000\043\000\075\000\044\000\074\000\000\000\
\\001\000\043\000\103\000\044\000\102\000\000\000\
\\001\000\043\000\131\000\044\000\102\000\000\000\
\\001\000\043\000\138\000\044\000\137\000\000\000\
\\001\000\043\000\190\000\000\000\
\\001\000\043\000\194\000\000\000\
\\001\000\043\000\197\000\000\000\
\\001\000\043\000\212\000\044\000\211\000\000\000\
\\001\000\043\000\232\000\000\000\
\\001\000\043\000\246\000\044\000\245\000\000\000\
\\001\000\044\000\005\000\000\000\
\\001\000\044\000\021\000\000\000\
\\001\000\044\000\022\000\000\000\
\\001\000\044\000\023\000\000\000\
\\001\000\044\000\024\000\000\000\
\\001\000\044\000\025\000\000\000\
\\001\000\044\000\026\000\000\000\
\\001\000\044\000\029\000\000\000\
\\001\000\044\000\030\000\000\000\
\\001\000\044\000\031\000\000\000\
\\001\000\044\000\032\000\000\000\
\\001\000\044\000\033\000\000\000\
\\001\000\044\000\034\000\000\000\
\\001\000\044\000\059\000\000\000\
\\001\000\044\000\061\000\000\000\
\\001\000\044\000\062\000\000\000\
\\001\000\044\000\064\000\000\000\
\\001\000\044\000\071\000\000\000\
\\001\000\044\000\105\000\000\000\
\\001\000\044\000\112\000\000\000\
\\001\000\044\000\114\000\000\000\
\\001\000\044\000\115\000\000\000\
\\001\000\044\000\116\000\000\000\
\\001\000\044\000\117\000\000\000\
\\001\000\044\000\118\000\000\000\
\\001\000\044\000\119\000\000\000\
\\001\000\044\000\120\000\000\000\
\\001\000\044\000\121\000\000\000\
\\001\000\044\000\122\000\000\000\
\\001\000\044\000\123\000\000\000\
\\001\000\044\000\124\000\000\000\
\\001\000\044\000\125\000\000\000\
\\001\000\044\000\126\000\000\000\
\\001\000\044\000\127\000\000\000\
\\001\000\044\000\128\000\000\000\
\\001\000\044\000\129\000\000\000\
\\001\000\044\000\133\000\000\000\
\\001\000\044\000\134\000\000\000\
\\001\000\044\000\168\000\000\000\
\\001\000\044\000\169\000\000\000\
\\001\000\044\000\178\000\000\000\
\\001\000\044\000\179\000\000\000\
\\001\000\044\000\180\000\000\000\
\\001\000\044\000\181\000\000\000\
\\001\000\044\000\182\000\000\000\
\\001\000\044\000\183\000\000\000\
\\001\000\044\000\184\000\000\000\
\\001\000\044\000\185\000\000\000\
\\001\000\044\000\186\000\000\000\
\\001\000\044\000\195\000\000\000\
\\001\000\044\000\210\000\000\000\
\\001\000\044\000\219\000\000\000\
\\001\000\044\000\220\000\000\000\
\\001\000\044\000\221\000\000\000\
\\001\000\044\000\222\000\000\000\
\\001\000\044\000\223\000\000\000\
\\001\000\044\000\224\000\000\000\
\\001\000\044\000\225\000\000\000\
\\001\000\044\000\243\000\000\000\
\\250\000\000\000\
\\251\000\000\000\
\\252\000\044\000\065\000\000\000\
\\253\000\000\000\
\\254\000\000\000\
\\255\000\000\000\
\\000\001\044\000\055\000\000\000\
\\001\001\000\000\
\\002\001\000\000\
\\003\001\000\000\
\\004\001\000\000\
\\005\001\000\000\
\\006\001\000\000\
\\007\001\000\000\
\\008\001\044\000\056\000\000\000\
\\009\001\000\000\
\\010\001\000\000\
\\011\001\044\000\066\000\000\000\
\\012\001\000\000\
\\013\001\000\000\
\\014\001\000\000\
\\015\001\000\000\
\\016\001\044\000\046\000\000\000\
\\017\001\000\000\
\\018\001\000\000\
\\019\001\000\000\
\\020\001\000\000\
\\021\001\000\000\
\\022\001\000\000\
\\023\001\000\000\
\\024\001\000\000\
\\025\001\000\000\
\\026\001\000\000\
\\027\001\000\000\
\\028\001\000\000\
\\029\001\000\000\
\\030\001\000\000\
\\031\001\000\000\
\\032\001\000\000\
\\033\001\000\000\
\\034\001\000\000\
\\035\001\000\000\
\\036\001\000\000\
\\037\001\000\000\
\\038\001\037\000\109\000\000\000\
\\039\001\044\000\196\000\000\000\
\\040\001\000\000\
\\041\001\000\000\
\\042\001\042\000\198\000\000\000\
\\043\001\000\000\
\\044\001\044\000\231\000\000\000\
\\045\001\000\000\
\\046\001\000\000\
\\047\001\000\000\
\\048\001\037\000\109\000\000\000\
\\049\001\000\000\
\\050\001\000\000\
\\051\001\000\000\
\\052\001\000\000\
\\053\001\000\000\
\\054\001\000\000\
\\055\001\000\000\
\\056\001\000\000\
\\057\001\000\000\
\\058\001\000\000\
\\059\001\000\000\
\\060\001\000\000\
\\061\001\000\000\
\\062\001\000\000\
\\063\001\000\000\
\\064\001\000\000\
\\065\001\000\000\
\\066\001\000\000\
\\067\001\000\000\
\\068\001\000\000\
\\069\001\000\000\
\\070\001\000\000\
\\071\001\000\000\
\\072\001\000\000\
\\073\001\000\000\
\\074\001\000\000\
\\075\001\000\000\
\\076\001\000\000\
\\077\001\000\000\
\\078\001\000\000\
\\079\001\000\000\
\\080\001\000\000\
\\081\001\000\000\
\\082\001\000\000\
\\083\001\000\000\
\\084\001\000\000\
\\085\001\000\000\
\\086\001\000\000\
\\087\001\000\000\
\\088\001\000\000\
\\089\001\000\000\
\\090\001\000\000\
\\091\001\000\000\
\\092\001\000\000\
\\093\001\000\000\
\"
val actionRowNumbers =
"\007\000\050\000\110\000\001\000\
\\109\000\051\000\052\000\053\000\
\\054\000\055\000\056\000\057\000\
\\058\000\059\000\060\000\061\000\
\\125\000\124\000\062\000\008\000\
\\036\000\037\000\009\000\037\000\
\\037\000\131\000\117\000\010\000\
\\011\000\008\000\011\000\037\000\
\\012\000\151\000\115\000\207\000\
\\180\000\123\000\013\000\063\000\
\\011\000\064\000\119\000\065\000\
\\010\000\133\000\134\000\116\000\
\\208\000\114\000\066\000\111\000\
\\126\000\008\000\036\000\067\000\
\\184\000\014\000\040\000\002\000\
\\015\000\132\000\016\000\014\000\
\\017\000\152\000\181\000\041\000\
\\068\000\006\000\069\000\178\000\
\\018\000\135\000\121\000\143\000\
\\138\000\070\000\071\000\072\000\
\\073\000\168\000\074\000\075\000\
\\146\000\076\000\077\000\078\000\
\\079\000\080\000\081\000\082\000\
\\083\000\084\000\085\000\118\000\
\\113\000\130\000\112\000\127\000\
\\018\000\183\000\042\000\006\000\
\\189\000\187\000\086\000\128\000\
\\087\000\185\000\019\000\043\000\
\\002\000\003\000\003\000\003\000\
\\038\000\039\000\004\000\030\000\
\\031\000\032\000\018\000\018\000\
\\033\000\018\000\018\000\018\000\
\\190\000\182\000\188\000\021\000\
\\016\000\122\000\179\000\024\000\
\\136\000\120\000\139\000\088\000\
\\089\000\175\000\018\000\153\000\
\\147\000\090\000\091\000\092\000\
\\141\000\140\000\093\000\094\000\
\\095\000\096\000\097\000\098\000\
\\197\000\195\000\191\000\025\000\
\\198\000\196\000\203\000\186\000\
\\044\000\129\000\003\000\003\000\
\\163\000\045\000\164\000\099\000\
\\155\000\154\000\046\000\157\000\
\\005\000\008\000\034\000\026\000\
\\026\000\035\000\026\000\026\000\
\\026\000\100\000\047\000\206\000\
\\137\000\177\000\176\000\165\000\
\\145\000\026\000\018\000\144\000\
\\027\000\148\000\101\000\149\000\
\\142\000\102\000\167\000\103\000\
\\104\000\105\000\106\000\107\000\
\\022\000\025\000\192\000\166\000\
\\156\000\160\000\159\000\048\000\
\\162\000\008\000\020\000\020\000\
\\016\000\020\000\020\000\023\000\
\\193\000\205\000\204\000\028\000\
\\108\000\027\000\158\000\150\000\
\\174\000\173\000\172\000\171\000\
\\170\000\169\000\049\000\200\000\
\\201\000\022\000\161\000\029\000\
\\199\000\194\000\202\000\000\000"
val gotoT =
"\
\\001\000\247\000\000\000\
\\000\000\
\\000\000\
\\002\000\004\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\006\000\026\000\007\000\025\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\014\000\034\000\045\000\033\000\000\000\
\\028\000\037\000\029\000\036\000\000\000\
\\009\000\039\000\000\000\
\\000\000\
\\009\000\042\000\000\000\
\\009\000\043\000\000\000\
\\000\000\
\\000\000\
\\008\000\045\000\000\000\
\\046\000\047\000\000\000\
\\045\000\049\000\000\000\
\\046\000\050\000\000\000\
\\009\000\051\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\030\000\055\000\000\000\
\\000\000\
\\046\000\058\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\008\000\061\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\045\000\065\000\000\000\
\\029\000\066\000\000\000\
\\032\000\068\000\033\000\067\000\000\000\
\\000\000\
\\026\000\070\000\000\000\
\\000\000\
\\010\000\077\000\012\000\076\000\013\000\075\000\025\000\074\000\000\000\
\\000\000\
\\000\000\
\\005\000\096\000\000\000\
\\026\000\098\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\033\000\102\000\000\000\
\\003\000\106\000\031\000\105\000\034\000\104\000\000\000\
\\000\000\
\\000\000\
\\003\000\111\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\106\000\034\000\128\000\000\000\
\\000\000\
\\000\000\
\\003\000\106\000\031\000\130\000\034\000\104\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\027\000\133\000\000\000\
\\000\000\
\\012\000\138\000\013\000\075\000\025\000\137\000\000\000\
\\025\000\139\000\000\000\
\\025\000\140\000\000\000\
\\025\000\141\000\000\000\
\\000\000\
\\000\000\
\\045\000\144\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\150\000\000\000\
\\003\000\151\000\000\000\
\\000\000\
\\003\000\153\000\000\000\
\\003\000\154\000\000\000\
\\003\000\155\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\036\000\158\000\037\000\157\000\040\000\156\000\000\000\
\\005\000\163\000\000\000\
\\000\000\
\\000\000\
\\004\000\164\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\003\000\171\000\021\000\170\000\022\000\169\000\023\000\168\000\000\000\
\\003\000\175\000\015\000\174\000\016\000\173\000\017\000\172\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\035\000\186\000\044\000\185\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\025\000\189\000\000\000\
\\025\000\190\000\000\000\
\\003\000\171\000\021\000\191\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\045\000\197\000\000\000\
\\045\000\199\000\000\000\
\\000\000\
\\024\000\201\000\000\000\
\\024\000\203\000\000\000\
\\000\000\
\\024\000\205\000\000\000\
\\024\000\206\000\000\000\
\\024\000\207\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\024\000\211\000\000\000\
\\003\000\175\000\017\000\212\000\000\000\
\\000\000\
\\018\000\215\000\019\000\214\000\020\000\213\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\036\000\226\000\037\000\157\000\038\000\225\000\040\000\156\000\
\\041\000\224\000\000\000\
\\044\000\228\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\045\000\231\000\000\000\
\\040\000\232\000\000\000\
\\040\000\233\000\000\000\
\\005\000\234\000\000\000\
\\040\000\235\000\000\000\
\\040\000\236\000\000\000\
\\037\000\237\000\040\000\156\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\039\000\238\000\000\000\
\\000\000\
\\020\000\242\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\036\000\226\000\037\000\157\000\038\000\225\000\040\000\156\000\
\\041\000\245\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 248
val numrules = 100
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; Char.ord(String.sub(!s,i)) + Char.ord(String.sub(!s,i+1)) * 256
end
val string_to_list = fn s' =>
    let val len = String.size s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.size s'
        fun f ()=
           if !index < len then convert_row() :: f()
           else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = Array.array(numstates+numrules,ERROR)
  val _ =let fun g i=(Array.update(memo,i,REDUCE(i-numstates)); g(i+1))
       fun f i =
            if i=numstates then g i
            else (Array.update(memo,i,SHIFT (STATE i)); f (i+1))
          in f 0 handle Subscript => ()
          end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => Array.sub(memo,(j-2))
end
val gotoT=Array.fromList(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=Array.fromList(actionRows) in fn i=>Array.sub(a,i) end
in Array.fromList(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = int
type arg = unit
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit | TAG of  (string)
 | NUMBER of  (int) | STRING of  (string) | dataset of  (string)
 | context of  (string) | metadata_wq of  (string)
 | acl_l of  (string list) | acl of  (string list)
 | value_store of  (V.value) | value of  (V.value)
 | val_l of  (string list) | value_list of  (V.value)
 | value_nil of  (V.value) | value_nildef of  (V.value)
 | metadata_wlist of  ( ( string * V.value )  list)
 | attr_store of  (A.attrstore)
 | attr_store_list of  (A.attrstore list)
 | store_mod_list of  (A.storemod list) | store_mod of  (A.storemod)
 | entry_path of  (string) | store_entry of  (A.storeentry)
 | store_entry_list of  (A.storeentry list) | acl_rights of  (string)
 | acl_id of  (string) | search_crit of  (A.searchcrit)
 | comparator of  (A.comparator) | s_l of  (A.sortitem list)
 | sort_list of  (A.sortitem list) | sort_item of  (A.sortitem)
 | metadata_type_q of  (string) | md_t_l of  (string list)
 | metadata_type_list of  (string list) | metadata of  (A.metadata)
 | md_l of  (A.metadata list) | metadata_list of  (A.metadata list)
 | context_list of  (string list) | makecontext of  (A.searchmod)
 | smod of  (A.searchmod) | smod_l of  (A.searchmod list)
 | search_mod_list of  (A.searchmod list) | acl_object of  (A.aclobj)
 | lang_tag of  (string) | lang_tag_l of  (string list)
 | lang_tag_list of  (string list) | time of  (string)
 | entryname of  (string) | attribute of  (string)
 | command of  (A.command) | line of  (A.line)
end
type svalue = MlyValue.svalue
type result = A.line
end
structure EC=
struct
open LrTable
val is_keyword =
fn _ => false
val preferred_change = 
nil
val noShift = 
fn (T 0) => true | (T 44) => true | _ => false
val showTerminal =
fn (T 0) => "EOF"
  | (T 1) => "AUTHENTICATE"
  | (T 2) => "NOOP"
  | (T 3) => "LOGOUT"
  | (T 4) => "DELETEACL"
  | (T 5) => "DELETEDSINCE"
  | (T 6) => "FREECONTEXT"
  | (T 7) => "GETQUOTA"
  | (T 8) => "LANG"
  | (T 9) => "LISTRIGHTS"
  | (T 10) => "MYRIGHTS"
  | (T 11) => "SEARCH"
  | (T 12) => "SETACL"
  | (T 13) => "STORE"
  | (T 14) => "UPDATECONTEXT"
  | (T 15) => "ISEQUAL"
  | (T 16) => "COMPARE"
  | (T 17) => "PREFIX"
  | (T 18) => "RANGE"
  | (T 19) => "COMPARESTRICT"
  | (T 20) => "SUBSTRING"
  | (T 21) => "DEPTH"
  | (T 22) => "HARDLIMIT"
  | (T 23) => "LIMIT"
  | (T 24) => "MAKECONTEXT"
  | (T 25) => "NOINHERIT"
  | (T 26) => "RETURN"
  | (T 27) => "SORT"
  | (T 28) => "NOTIFY"
  | (T 29) => "ENUMERATE"
  | (T 30) => "ALL"
  | (T 31) => "NOT"
  | (T 32) => "OR"
  | (T 33) => "AND"
  | (T 34) => "NOCREATE"
  | (T 35) => "UNCHANGEDSINCE"
  | (T 36) => "STRING"
  | (T 37) => "NUMBER"
  | (T 38) => "TAG"
  | (T 39) => "DEFAULT"
  | (T 40) => "NIL"
  | (T 41) => "LPAREN"
  | (T 42) => "RPAREN"
  | (T 43) => "SP"
  | (T 44) => "CRLF"
  | (T 45) => "LEXERROR"
  | _ => "bogus-term"
local open Header in
val errtermvalue=
fn (T 36) => MlyValue.STRING(("")) | 
(T 37) => MlyValue.NUMBER((0)) | 
(T 38) => MlyValue.TAG(("*")) | 
_ => MlyValue.VOID
end
val terms = (T 0) :: (T 1) :: (T 2) :: (T 3) :: (T 4) :: (T 5) :: (T 6
) :: (T 7) :: (T 8) :: (T 9) :: (T 10) :: (T 11) :: (T 12) :: (T 13)
 :: (T 14) :: (T 15) :: (T 16) :: (T 17) :: (T 18) :: (T 19) :: (T 20)
 :: (T 21) :: (T 22) :: (T 23) :: (T 24) :: (T 25) :: (T 26) :: (T 27)
 :: (T 28) :: (T 29) :: (T 30) :: (T 31) :: (T 32) :: (T 33) :: (T 34)
 :: (T 35) :: (T 39) :: (T 40) :: (T 41) :: (T 42) :: (T 43) :: (T 44)
 :: (T 45) :: nil
end
structure Actions =
struct 
exception mlyAction of int
local open Header in
val actions = 
fn (i392,defaultPos,stack,
    (()):arg) =>
case (i392,stack)
of (0,(_,(MlyValue.command command,_,command1right))::_::(_,(
MlyValue.TAG TAG,TAG1left,_))::rest671) => let val result=
MlyValue.line((A.Line(TAG, command)))
 in (LrTable.NT 0,(result,TAG1left,command1right),rest671) end
| (1,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.line((A.BareString(STRING)))
 in (LrTable.NT 0,(result,STRING1left,STRING1right),rest671) end
| (2,(_,(MlyValue.acl_object acl_object,_,acl_object1right))::_::(_,(_
,DELETEACL1left,_))::rest671) => let val result=MlyValue.command((
A.DeleteAcl(acl_object, NONE)))
 in (LrTable.NT 1,(result,DELETEACL1left,acl_object1right),rest671)
 end
| (3,(_,(MlyValue.acl_id acl_id,_,acl_id1right))::_::(_,(
MlyValue.acl_object acl_object,_,_))::_::(_,(_,DELETEACL1left,_))::
rest671) => let val result=MlyValue.command((
A.DeleteAcl(acl_object, SOME(acl_id))))
 in (LrTable.NT 1,(result,DELETEACL1left,acl_id1right),rest671) end
| (4,(_,(MlyValue.time time,_,time1right))::_::(_,(MlyValue.dataset 
dataset,_,_))::_::(_,(_,DELETEDSINCE1left,_))::rest671) => let val 
result=MlyValue.command((A.DeletedSince(dataset, time)))
 in (LrTable.NT 1,(result,DELETEDSINCE1left,time1right),rest671) end
| (5,(_,(MlyValue.context context,_,context1right))::_::(_,(_,
FREECONTEXT1left,_))::rest671) => let val result=MlyValue.command((
A.FreeContext(context)))
 in (LrTable.NT 1,(result,FREECONTEXT1left,context1right),rest671) end
| (6,(_,(MlyValue.context_list context_list,_,context_list1right))::_
::(_,(_,UPDATECONTEXT1left,_))::rest671) => let val result=
MlyValue.command((A.UpdateContext(context_list)))
 in (LrTable.NT 1,(result,UPDATECONTEXT1left,context_list1right),
rest671) end
| (7,(_,(MlyValue.dataset dataset,_,dataset1right))::_::(_,(_,
GETQUOTA1left,_))::rest671) => let val result=MlyValue.command((
A.GetQuota(dataset)))
 in (LrTable.NT 1,(result,GETQUOTA1left,dataset1right),rest671) end
| (8,(_,(MlyValue.lang_tag_list lang_tag_list,_,lang_tag_list1right))
::(_,(_,LANG1left,_))::rest671) => let val result=MlyValue.command((
A.Lang(lang_tag_list)))
 in (LrTable.NT 1,(result,LANG1left,lang_tag_list1right),rest671) end
| (9,(_,(MlyValue.STRING STRING,_,STRING1right))::_::(_,(
MlyValue.acl_object acl_object,_,_))::_::(_,(_,LISTRIGHTS1left,_))::
rest671) => let val result=MlyValue.command((
A.ListRights(acl_object, STRING)))
 in (LrTable.NT 1,(result,LISTRIGHTS1left,STRING1right),rest671) end
| (10,(_,(MlyValue.acl_object acl_object,_,acl_object1right))::_::(_,(
_,MYRIGHTS1left,_))::rest671) => let val result=MlyValue.command((
A.MyRights(acl_object)))
 in (LrTable.NT 1,(result,MYRIGHTS1left,acl_object1right),rest671) end
| (11,(_,(MlyValue.search_crit search_crit,_,search_crit1right))::_::(
_,(MlyValue.search_mod_list search_mod_list,_,_))::_::(_,(
MlyValue.STRING STRING,_,_))::_::(_,(_,SEARCH1left,_))::rest671) => 
let val result=MlyValue.command((
A.Search(STRING, List.rev search_mod_list,
					  search_crit)))
 in (LrTable.NT 1,(result,SEARCH1left,search_crit1right),rest671) end
| (12,(_,(MlyValue.search_crit search_crit,_,search_crit1right))::_::(
_,(MlyValue.STRING STRING,_,_))::_::(_,(_,SEARCH1left,_))::rest671)
 => let val result=MlyValue.command((
A.Search(STRING, nil,
					  search_crit)))
 in (LrTable.NT 1,(result,SEARCH1left,search_crit1right),rest671) end
| (13,(_,(MlyValue.acl_rights acl_rights,_,acl_rights1right))::_::(_,(
MlyValue.acl_id acl_id,_,_))::_::(_,(MlyValue.acl_object acl_object,_,
_))::_::(_,(_,SETACL1left,_))::rest671) => let val result=
MlyValue.command((A.SetAcl(acl_object, acl_id, acl_rights)))
 in (LrTable.NT 1,(result,SETACL1left,acl_rights1right),rest671) end
| (14,(_,(MlyValue.store_entry_list store_entry_list,_,
store_entry_list1right))::_::(_,(_,STORE1left,_))::rest671) => let 
val result=MlyValue.command((A.Store(store_entry_list)))
 in (LrTable.NT 1,(result,STORE1left,store_entry_list1right),rest671)
 end
| (15,(_,(_,NOOP1left,NOOP1right))::rest671) => let val result=
MlyValue.command((A.Noop))
 in (LrTable.NT 1,(result,NOOP1left,NOOP1right),rest671) end
| (16,(_,(_,LOGOUT1left,LOGOUT1right))::rest671) => let val result=
MlyValue.command((A.Logout))
 in (LrTable.NT 1,(result,LOGOUT1left,LOGOUT1right),rest671) end
| (17,(_,(MlyValue.STRING STRING,_,STRING1right))::_::(_,(_,
AUTHENTICATE1left,_))::rest671) => let val result=MlyValue.command((
A.Authenticate(STRING, NONE)))
 in (LrTable.NT 1,(result,AUTHENTICATE1left,STRING1right),rest671) end
| (18,(_,(MlyValue.STRING STRING2,_,STRING2right))::_::(_,(
MlyValue.STRING STRING1,_,_))::_::(_,(_,AUTHENTICATE1left,_))::rest671
) => let val result=MlyValue.command((
A.Authenticate(STRING1, SOME(STRING2))))
 in (LrTable.NT 1,(result,AUTHENTICATE1left,STRING2right),rest671) end
| (19,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.attribute((STRING))
 in (LrTable.NT 2,(result,STRING1left,STRING1right),rest671) end
| (20,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.entryname((STRING))
 in (LrTable.NT 3,(result,STRING1left,STRING1right),rest671) end
| (21,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.time((STRING))
 in (LrTable.NT 4,(result,STRING1left,STRING1right),rest671) end
| (22,(_,(MlyValue.lang_tag_l lang_tag_l,lang_tag_l1left,
lang_tag_l1right))::rest671) => let val result=MlyValue.lang_tag_list(
(List.rev(lang_tag_l)))
 in (LrTable.NT 5,(result,lang_tag_l1left,lang_tag_l1right),rest671)
 end
| (23,(_,(MlyValue.lang_tag lang_tag,_,lang_tag1right))::_::(_,(
MlyValue.lang_tag_l lang_tag_l,lang_tag_l1left,_))::rest671) => let 
val result=MlyValue.lang_tag_l((lang_tag::lang_tag_l))
 in (LrTable.NT 6,(result,lang_tag_l1left,lang_tag1right),rest671) end
| (24,(_,(MlyValue.lang_tag lang_tag,_,lang_tag1right))::(_,(_,SP1left
,_))::rest671) => let val result=MlyValue.lang_tag_l((lang_tag::nil))
 in (LrTable.NT 6,(result,SP1left,lang_tag1right),rest671) end
| (25,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.lang_tag((STRING))
 in (LrTable.NT 7,(result,STRING1left,STRING1right),rest671) end
| (26,(_,(_,_,RPAREN1right))::(_,(MlyValue.dataset dataset,_,_))::(_,(
_,LPAREN1left,_))::rest671) => let val result=MlyValue.acl_object((
A.AclObj(dataset, NONE, NONE)))
 in (LrTable.NT 8,(result,LPAREN1left,RPAREN1right),rest671) end
| (27,(_,(_,_,RPAREN1right))::(_,(MlyValue.attribute attribute,_,_))::
_::(_,(MlyValue.dataset dataset,_,_))::(_,(_,LPAREN1left,_))::rest671)
 => let val result=MlyValue.acl_object((
A.AclObj(dataset, SOME(attribute), NONE)))
 in (LrTable.NT 8,(result,LPAREN1left,RPAREN1right),rest671) end
| (28,(_,(_,_,RPAREN1right))::(_,(MlyValue.entryname entryname,_,_))::
_::(_,(MlyValue.attribute attribute,_,_))::_::(_,(MlyValue.dataset 
dataset,_,_))::(_,(_,LPAREN1left,_))::rest671) => let val result=
MlyValue.acl_object((
A.AclObj(dataset, SOME(attribute),
					  SOME(entryname))))
 in (LrTable.NT 8,(result,LPAREN1left,RPAREN1right),rest671) end
| (29,(_,(MlyValue.smod smod,smod1left,smod1right))::rest671) => let 
val result=MlyValue.search_mod_list((smod::nil))
 in (LrTable.NT 9,(result,smod1left,smod1right),rest671) end
| (30,(_,(MlyValue.smod smod,_,smod1right))::_::(_,(
MlyValue.search_mod_list search_mod_list,search_mod_list1left,_))::
rest671) => let val result=MlyValue.search_mod_list((
smod::search_mod_list))
 in (LrTable.NT 9,(result,search_mod_list1left,smod1right),rest671)
 end
| (31,(_,(MlyValue.NUMBER NUMBER,_,NUMBER1right))::_::(_,(_,DEPTH1left
,_))::rest671) => let val result=MlyValue.smod((A.Depth(NUMBER)))
 in (LrTable.NT 11,(result,DEPTH1left,NUMBER1right),rest671) end
| (32,(_,(MlyValue.NUMBER NUMBER,_,NUMBER1right))::_::(_,(_,
HARDLIMIT1left,_))::rest671) => let val result=MlyValue.smod((
A.HardLimit(NUMBER)))
 in (LrTable.NT 11,(result,HARDLIMIT1left,NUMBER1right),rest671) end
| (33,(_,(MlyValue.NUMBER NUMBER2,_,NUMBER2right))::_::(_,(
MlyValue.NUMBER NUMBER1,_,_))::_::(_,(_,LIMIT1left,_))::rest671) => 
let val result=MlyValue.smod((A.Limit(NUMBER1, NUMBER2)))
 in (LrTable.NT 11,(result,LIMIT1left,NUMBER2right),rest671) end
| (34,(_,(MlyValue.makecontext makecontext,makecontext1left,
makecontext1right))::rest671) => let val result=MlyValue.smod((
makecontext))
 in (LrTable.NT 11,(result,makecontext1left,makecontext1right),rest671
) end
| (35,(_,(_,_,RPAREN1right))::(_,(MlyValue.metadata_list metadata_list
,_,_))::_::_::(_,(_,RETURN1left,_))::rest671) => let val result=
MlyValue.smod((A.Return(metadata_list)))
 in (LrTable.NT 11,(result,RETURN1left,RPAREN1right),rest671) end
| (36,(_,(_,_,RPAREN1right))::(_,(MlyValue.sort_list sort_list,_,_))::
_::_::(_,(_,SORT1left,_))::rest671) => let val result=MlyValue.smod((
A.Sort(sort_list)))
 in (LrTable.NT 11,(result,SORT1left,RPAREN1right),rest671) end
| (37,(_,(_,NOINHERIT1left,NOINHERIT1right))::rest671) => let val 
result=MlyValue.smod((A.Noinherit))
 in (LrTable.NT 11,(result,NOINHERIT1left,NOINHERIT1right),rest671)
 end
| (38,(_,(MlyValue.context context,_,context1right))::_::(_,(_,
MAKECONTEXT1left,_))::rest671) => let val result=MlyValue.makecontext(
(A.MakeContext(false, false, context)))
 in (LrTable.NT 12,(result,MAKECONTEXT1left,context1right),rest671)
 end
| (39,(_,(MlyValue.context context,_,context1right))::_::_::_::(_,(_,
MAKECONTEXT1left,_))::rest671) => let val result=MlyValue.makecontext(
(A.MakeContext(true, false, context)))
 in (LrTable.NT 12,(result,MAKECONTEXT1left,context1right),rest671)
 end
| (40,(_,(MlyValue.context context,_,context1right))::_::_::_::(_,(_,
MAKECONTEXT1left,_))::rest671) => let val result=MlyValue.makecontext(
(A.MakeContext(false, true, context)))
 in (LrTable.NT 12,(result,MAKECONTEXT1left,context1right),rest671)
 end
| (41,(_,(MlyValue.context context,_,context1right))::_::_::_::_::_::(
_,(_,MAKECONTEXT1left,_))::rest671) => let val result=
MlyValue.makecontext((A.MakeContext(true, true, context)))
 in (LrTable.NT 12,(result,MAKECONTEXT1left,context1right),rest671)
 end
| (42,(_,(MlyValue.context context,context1left,context1right))::
rest671) => let val result=MlyValue.context_list((context::nil))
 in (LrTable.NT 13,(result,context1left,context1right),rest671) end
| (43,(_,(MlyValue.context context,_,context1right))::_::(_,(
MlyValue.context_list context_list,context_list1left,_))::rest671) => 
let val result=MlyValue.context_list((context::context_list))
 in (LrTable.NT 13,(result,context_list1left,context1right),rest671)
 end
| (44,rest671) => let val result=MlyValue.metadata_list((nil))
 in (LrTable.NT 14,(result,defaultPos,defaultPos),rest671) end
| (45,(_,(MlyValue.md_l md_l,md_l1left,md_l1right))::rest671) => let 
val result=MlyValue.metadata_list((List.rev(md_l)))
 in (LrTable.NT 14,(result,md_l1left,md_l1right),rest671) end
| (46,(_,(MlyValue.metadata metadata,metadata1left,metadata1right))::
rest671) => let val result=MlyValue.md_l((metadata::nil))
 in (LrTable.NT 15,(result,metadata1left,metadata1right),rest671) end
| (47,(_,(MlyValue.metadata metadata,_,metadata1right))::_::(_,(
MlyValue.md_l md_l,md_l1left,_))::rest671) => let val result=
MlyValue.md_l((metadata::md_l))
 in (LrTable.NT 15,(result,md_l1left,metadata1right),rest671) end
| (48,(_,(MlyValue.attribute attribute,attribute1left,attribute1right)
)::rest671) => let val result=MlyValue.metadata((
A.MetaData(attribute, nil)))
 in (LrTable.NT 16,(result,attribute1left,attribute1right),rest671)
 end
| (49,(_,(_,_,RPAREN1right))::(_,(MlyValue.metadata_type_list 
metadata_type_list,_,_))::_::(_,(MlyValue.attribute attribute,
attribute1left,_))::rest671) => let val result=MlyValue.metadata((
A.MetaData(attribute, metadata_type_list)))
 in (LrTable.NT 16,(result,attribute1left,RPAREN1right),rest671) end
| (50,(_,(MlyValue.md_t_l md_t_l,md_t_l1left,md_t_l1right))::rest671)
 => let val result=MlyValue.metadata_type_list((List.rev(md_t_l)))
 in (LrTable.NT 17,(result,md_t_l1left,md_t_l1right),rest671) end
| (51,(_,(MlyValue.metadata_type_q metadata_type_q,
metadata_type_q1left,metadata_type_q1right))::rest671) => let val 
result=MlyValue.md_t_l((metadata_type_q::nil))
 in (LrTable.NT 18,(result,metadata_type_q1left,metadata_type_q1right)
,rest671) end
| (52,(_,(MlyValue.metadata_type_q metadata_type_q,_,
metadata_type_q1right))::_::(_,(MlyValue.md_t_l md_t_l,md_t_l1left,_))
::rest671) => let val result=MlyValue.md_t_l((metadata_type_q::md_t_l)
)
 in (LrTable.NT 18,(result,md_t_l1left,metadata_type_q1right),rest671)
 end
| (53,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.metadata_type_q((STRING))
 in (LrTable.NT 19,(result,STRING1left,STRING1right),rest671) end
| (54,(_,(MlyValue.s_l s_l,s_l1left,s_l1right))::rest671) => let val 
result=MlyValue.sort_list((List.rev(s_l)))
 in (LrTable.NT 21,(result,s_l1left,s_l1right),rest671) end
| (55,(_,(MlyValue.sort_item sort_item,sort_item1left,sort_item1right)
)::rest671) => let val result=MlyValue.s_l((sort_item::nil))
 in (LrTable.NT 22,(result,sort_item1left,sort_item1right),rest671)
 end
| (56,(_,(MlyValue.sort_item sort_item,_,sort_item1right))::(_,(
MlyValue.s_l s_l,s_l1left,_))::rest671) => let val result=MlyValue.s_l
((sort_item::s_l))
 in (LrTable.NT 22,(result,s_l1left,sort_item1right),rest671) end
| (57,(_,(MlyValue.comparator comparator,_,comparator1right))::_::(_,(
MlyValue.attribute attribute,attribute1left,_))::rest671) => let val 
result=MlyValue.sort_item((A.SortItem(attribute, comparator)))
 in (LrTable.NT 20,(result,attribute1left,comparator1right),rest671)
 end
| (58,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.comparator((A.Comparator(STRING)))
 in (LrTable.NT 23,(result,STRING1left,STRING1right),rest671) end
| (59,(_,(_,ALL1left,ALL1right))::rest671) => let val result=
MlyValue.search_crit((A.All))
 in (LrTable.NT 24,(result,ALL1left,ALL1right),rest671) end
| (60,(_,(MlyValue.value_nil value_nil,_,value_nil1right))::_::(_,(
MlyValue.comparator comparator,_,_))::_::(_,(MlyValue.attribute 
attribute,_,_))::_::(_,(_,ISEQUAL1left,_))::rest671) => let val result
=MlyValue.search_crit((A.Equal(attribute, comparator, value_nil)))
 in (LrTable.NT 24,(result,ISEQUAL1left,value_nil1right),rest671) end
| (61,(_,(MlyValue.value value,_,value1right))::_::(_,(
MlyValue.comparator comparator,_,_))::_::(_,(MlyValue.attribute 
attribute,_,_))::_::(_,(_,COMPARE1left,_))::rest671) => let val result
=MlyValue.search_crit((A.Compare(attribute, comparator, value)))
 in (LrTable.NT 24,(result,COMPARE1left,value1right),rest671) end
| (62,(_,(MlyValue.value value,_,value1right))::_::(_,(
MlyValue.comparator comparator,_,_))::_::(_,(MlyValue.attribute 
attribute,_,_))::_::(_,(_,PREFIX1left,_))::rest671) => let val result=
MlyValue.search_crit((A.Prefix(attribute, comparator, value)))
 in (LrTable.NT 24,(result,PREFIX1left,value1right),rest671) end
| (63,(_,(MlyValue.time time,_,time1right))::_::(_,(MlyValue.NUMBER 
NUMBER2,_,_))::_::(_,(MlyValue.NUMBER NUMBER1,_,_))::_::(_,(_,
RANGE1left,_))::rest671) => let val result=MlyValue.search_crit((
A.Range(NUMBER1, NUMBER2, time)))
 in (LrTable.NT 24,(result,RANGE1left,time1right),rest671) end
| (64,(_,(MlyValue.value value,_,value1right))::_::(_,(
MlyValue.comparator comparator,_,_))::_::(_,(MlyValue.attribute 
attribute,_,_))::_::(_,(_,COMPARESTRICT1left,_))::rest671) => let val 
result=MlyValue.search_crit((A.Strict(attribute, comparator, value)))
 in (LrTable.NT 24,(result,COMPARESTRICT1left,value1right),rest671)
 end
| (65,(_,(MlyValue.value value,_,value1right))::_::(_,(
MlyValue.comparator comparator,_,_))::_::(_,(MlyValue.attribute 
attribute,_,_))::_::(_,(_,SUBSTRING1left,_))::rest671) => let val 
result=MlyValue.search_crit((A.Substr(attribute, comparator, value)))
 in (LrTable.NT 24,(result,SUBSTRING1left,value1right),rest671) end
| (66,(_,(MlyValue.search_crit search_crit,_,search_crit1right))::_::(
_,(_,NOT1left,_))::rest671) => let val result=MlyValue.search_crit((
A.Not(search_crit)))
 in (LrTable.NT 24,(result,NOT1left,search_crit1right),rest671) end
| (67,(_,(_,_,search_crit2right))::_::(_,(MlyValue.search_crit 
search_crit,_,_))::_::(_,(_,OR1left,_))::rest671) => let val result=
MlyValue.search_crit((A.Or(search_crit, search_crit)))
 in (LrTable.NT 24,(result,OR1left,search_crit2right),rest671) end
| (68,(_,(_,_,search_crit2right))::_::(_,(MlyValue.search_crit 
search_crit,_,_))::_::(_,(_,AND1left,_))::rest671) => let val result=
MlyValue.search_crit((A.And(search_crit, search_crit)))
 in (LrTable.NT 24,(result,AND1left,search_crit2right),rest671) end
| (69,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.acl_id((STRING))
 in (LrTable.NT 25,(result,STRING1left,STRING1right),rest671) end
| (70,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.acl_rights((STRING))
 in (LrTable.NT 26,(result,STRING1left,STRING1right),rest671) end
| (71,(_,(MlyValue.store_entry store_entry,store_entry1left,
store_entry1right))::rest671) => let val result=
MlyValue.store_entry_list((store_entry::nil))
 in (LrTable.NT 27,(result,store_entry1left,store_entry1right),rest671
) end
| (72,(_,(MlyValue.store_entry store_entry,_,store_entry1right))::_::(
_,(MlyValue.store_entry_list store_entry_list,store_entry_list1left,_)
)::rest671) => let val result=MlyValue.store_entry_list((
store_entry::store_entry_list))
 in (LrTable.NT 27,(result,store_entry_list1left,store_entry1right),
rest671) end
| (73,(_,(_,_,RPAREN1right))::(_,(MlyValue.attr_store_list 
attr_store_list,_,_))::(_,(MlyValue.store_mod_list store_mod_list,_,_)
)::(_,(MlyValue.entry_path entry_path,_,_))::(_,(_,LPAREN1left,_))::
rest671) => let val result=MlyValue.store_entry((
A.StoreEntry(entry_path, store_mod_list,
					      attr_store_list)))
 in (LrTable.NT 28,(result,LPAREN1left,RPAREN1right),rest671) end
| (74,(_,(_,_,RPAREN1right))::(_,(MlyValue.attr_store_list 
attr_store_list,_,_))::(_,(MlyValue.entry_path entry_path,_,_))::(_,(_
,LPAREN1left,_))::rest671) => let val result=MlyValue.store_entry((
A.StoreEntry(entry_path, nil,
					      attr_store_list)))
 in (LrTable.NT 28,(result,LPAREN1left,RPAREN1right),rest671) end
| (75,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.entry_path((STRING))
 in (LrTable.NT 29,(result,STRING1left,STRING1right),rest671) end
| (76,(_,(_,NOCREATE1left,NOCREATE1right))::rest671) => let val result
=MlyValue.store_mod((A.NoCreate))
 in (LrTable.NT 30,(result,NOCREATE1left,NOCREATE1right),rest671) end
| (77,(_,(MlyValue.time time,_,time1right))::_::(_,(_,
UNCHANGEDSINCE1left,_))::rest671) => let val result=MlyValue.store_mod
((A.UnchangedSince(time)))
 in (LrTable.NT 30,(result,UNCHANGEDSINCE1left,time1right),rest671)
 end
| (78,(_,(MlyValue.store_mod store_mod,_,store_mod1right))::(_,(_,
SP1left,_))::rest671) => let val result=MlyValue.store_mod_list((
store_mod::nil))
 in (LrTable.NT 31,(result,SP1left,store_mod1right),rest671) end
| (79,(_,(MlyValue.store_mod store_mod,_,store_mod1right))::_::(_,(
MlyValue.store_mod_list store_mod_list,store_mod_list1left,_))::
rest671) => let val result=MlyValue.store_mod_list((
store_mod::store_mod_list))
 in (LrTable.NT 31,(result,store_mod_list1left,store_mod1right),
rest671) end
| (80,(_,(MlyValue.attr_store attr_store,_,attr_store1right))::(_,(_,
SP1left,_))::rest671) => let val result=MlyValue.attr_store_list((
attr_store::nil))
 in (LrTable.NT 32,(result,SP1left,attr_store1right),rest671) end
| (81,(_,(MlyValue.attr_store attr_store,_,attr_store1right))::_::(_,(
MlyValue.attr_store_list attr_store_list,attr_store_list1left,_))::
rest671) => let val result=MlyValue.attr_store_list((
attr_store::attr_store_list))
 in (LrTable.NT 32,(result,attr_store_list1left,attr_store1right),
rest671) end
| (82,(_,(MlyValue.value_nildef value_nildef,_,value_nildef1right))::_
::(_,(MlyValue.attribute attribute,attribute1left,_))::rest671) => 
let val result=MlyValue.attr_store((
A.AttrStoreValue(attribute, value_nildef)))
 in (LrTable.NT 33,(result,attribute1left,value_nildef1right),rest671)
 end
| (83,(_,(_,_,RPAREN1right))::(_,(MlyValue.metadata_wlist 
metadata_wlist,_,_))::_::_::(_,(MlyValue.attribute attribute,
attribute1left,_))::rest671) => let val result=MlyValue.attr_store((
A.AttrStoreMeta(attribute, metadata_wlist)))
 in (LrTable.NT 33,(result,attribute1left,RPAREN1right),rest671) end
| (84,(_,(MlyValue.value_store value_store,_,value_store1right))::_::(
_,(MlyValue.metadata_wq metadata_wq,metadata_wq1left,_))::rest671) => 
let val result=MlyValue.metadata_wlist((
(metadata_wq, value_store)::nil))
 in (LrTable.NT 34,(result,metadata_wq1left,value_store1right),rest671
) end
| (85,(_,(MlyValue.value_store value_store,_,value_store1right))::_::(
_,(MlyValue.metadata_wq metadata_wq,_,_))::_::(_,(
MlyValue.metadata_wlist metadata_wlist,metadata_wlist1left,_))::
rest671) => let val result=MlyValue.metadata_wlist((
(metadata_wq, value_store)::metadata_wlist))
 in (LrTable.NT 34,(result,metadata_wlist1left,value_store1right),
rest671) end
| (86,(_,(MlyValue.value_nil value_nil,value_nil1left,value_nil1right)
)::rest671) => let val result=MlyValue.value_nildef((value_nil))
 in (LrTable.NT 35,(result,value_nil1left,value_nil1right),rest671)
 end
| (87,(_,(_,DEFAULT1left,DEFAULT1right))::rest671) => let val result=
MlyValue.value_nildef((V.Default))
 in (LrTable.NT 35,(result,DEFAULT1left,DEFAULT1right),rest671) end
| (88,(_,(MlyValue.value value,value1left,value1right))::rest671) => 
let val result=MlyValue.value_nil((value))
 in (LrTable.NT 36,(result,value1left,value1right),rest671) end
| (89,(_,(_,NIL1left,NIL1right))::rest671) => let val result=
MlyValue.value_nil((V.Nil))
 in (LrTable.NT 36,(result,NIL1left,NIL1right),rest671) end
| (90,(_,(_,_,RPAREN1right))::(_,(MlyValue.val_l val_l,_,_))::(_,(_,
LPAREN1left,_))::rest671) => let val result=MlyValue.value_list((
V.List(val_l)))
 in (LrTable.NT 37,(result,LPAREN1left,RPAREN1right),rest671) end
| (91,(_,(_,_,RPAREN1right))::(_,(_,LPAREN1left,_))::rest671) => let 
val result=MlyValue.value_list((V.List(nil)))
 in (LrTable.NT 37,(result,LPAREN1left,RPAREN1right),rest671) end
| (92,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.val_l((STRING::nil))
 in (LrTable.NT 38,(result,STRING1left,STRING1right),rest671) end
| (93,(_,(MlyValue.STRING STRING,_,STRING1right))::_::(_,(
MlyValue.val_l val_l,val_l1left,_))::rest671) => let val result=
MlyValue.val_l((STRING::val_l))
 in (LrTable.NT 38,(result,val_l1left,STRING1right),rest671) end
| (94,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.value((V.Single(STRING)))
 in (LrTable.NT 39,(result,STRING1left,STRING1right),rest671) end
| (95,(_,(MlyValue.value_nildef value_nildef,value_nildef1left,
value_nildef1right))::rest671) => let val result=MlyValue.value_store(
(value_nildef))
 in (LrTable.NT 40,(result,value_nildef1left,value_nildef1right),
rest671) end
| (96,(_,(MlyValue.value_list value_list,value_list1left,
value_list1right))::rest671) => let val result=MlyValue.value_store((
value_list))
 in (LrTable.NT 40,(result,value_list1left,value_list1right),rest671)
 end
| (97,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.metadata_wq((STRING))
 in (LrTable.NT 43,(result,STRING1left,STRING1right),rest671) end
| (98,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.context((STRING))
 in (LrTable.NT 44,(result,STRING1left,STRING1right),rest671) end
| (99,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.dataset((STRING))
 in (LrTable.NT 45,(result,STRING1left,STRING1right),rest671) end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.line x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a 
end
end
structure Tokens : Acap_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID,p1,p2))
fun AUTHENTICATE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.VOID,p1,p2))
fun NOOP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.VOID,p1,p2))
fun LOGOUT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.VOID,p1,p2))
fun DELETEACL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.VOID,p1,p2))
fun DELETEDSINCE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.VOID,p1,p2))
fun FREECONTEXT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.VOID,p1,p2))
fun GETQUOTA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.VOID,p1,p2))
fun LANG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.VOID,p1,p2))
fun LISTRIGHTS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.VOID,p1,p2))
fun MYRIGHTS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.VOID,p1,p2))
fun SEARCH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID,p1,p2))
fun SETACL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID,p1,p2))
fun STORE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun UPDATECONTEXT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun ISEQUAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.VOID,p1,p2))
fun COMPARE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID,p1,p2))
fun PREFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID,p1,p2))
fun RANGE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID,p1,p2))
fun COMPARESTRICT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun SUBSTRING (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun DEPTH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun HARDLIMIT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun LIMIT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun MAKECONTEXT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun NOINHERIT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun RETURN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID,p1,p2))
fun SORT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun NOTIFY (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun ENUMERATE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun ALL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID,p1,p2))
fun NOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID,p1,p2))
fun OR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.VOID,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID,p1,p2))
fun NOCREATE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.VOID,p1,p2))
fun UNCHANGEDSINCE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID,p1,p2))
fun STRING (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.STRING i,p1,p2))
fun NUMBER (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.NUMBER i,p1,p2))
fun TAG (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.TAG i,p1,p2))
fun DEFAULT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID,p1,p2))
fun NIL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.VOID,p1,p2))
fun LPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(
ParserData.MlyValue.VOID,p1,p2))
fun RPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 42,(
ParserData.MlyValue.VOID,p1,p2))
fun SP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 43,(
ParserData.MlyValue.VOID,p1,p2))
fun CRLF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 44,(
ParserData.MlyValue.VOID,p1,p2))
fun LEXERROR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 45,(
ParserData.MlyValue.VOID,p1,p2))
end
end
